
# $Id: Makefile.PL,v 1.7 2002/11/27 17:01:32 theory Exp $

use ExtUtils::MakeMaker;
use Config;
use strict;

use DBI 1.00;
use DBI::DBD;

my $lib;
BEGIN {
    my %sep = (MacOS   => ':',
               MSWin32 => '\\',
               os2     => '\\',
               VMS     => '\\',
               NetWare => '\\',
               dos     => '\\');
    my $s = $sep{$^O} || '/';
    $lib = join $s, 't', 'lib';
}

use lib $lib;
print "Configuring Pg\n";
print "Remember to actually read the README file !\n";

my $POSTGRES_INCLUDE;
my $POSTGRES_LIB;

if ((!$ENV{POSTGRES_INCLUDE} or !$ENV{POSTGRES_LIB}) and !$ENV{POSTGRES_HOME}) {
    # Use App::Info to get the data we need.
    require App::Info::RDBMS::PostgreSQL;
    require App::Info::Handler::Prompt;
    my $p = App::Info::Handler::Prompt->new;
    my $pg = App::Info::RDBMS::PostgreSQL->new(on_unknown => $p);
    $POSTGRES_INCLUDE = $pg->inc_dir;
    $POSTGRES_LIB     = $pg->lib_dir;
} elsif ((!$ENV{POSTGRES_INCLUDE} or !$ENV{POSTGRES_LIB}) and $ENV{POSTGRES_HOME}) {
    $POSTGRES_INCLUDE = "$ENV{POSTGRES_HOME}/include";
    $POSTGRES_LIB     = "$ENV{POSTGRES_HOME}/lib";
} else {
    $POSTGRES_INCLUDE = "$ENV{POSTGRES_INCLUDE}";
    $POSTGRES_LIB     = "$ENV{POSTGRES_LIB}";
}

my $os = $^O;
print "OS: $os\n";

my $dbi_arch_dir;
if ($os eq 'MSWin32') {
    $dbi_arch_dir = "\$(INSTALLSITEARCH)/auto/DBI";
} else {
    $dbi_arch_dir = dbd_dbi_arch_dir();
}

my %opts = (
    NAME         => 'DBD::Pg',
    VERSION_FROM => 'Pg.pm',
    INC          => "-I$POSTGRES_INCLUDE -I$dbi_arch_dir",
    OBJECT       => "Pg\$(OBJ_EXT) dbdimp\$(OBJ_EXT)",
    LIBS         => ["-L$POSTGRES_LIB -lpq"],
    AUTHOR       => 'http://gborg.postgresql.org/project/dbdpg/projdisplay.php',
    ABSTRACT     => 'PostgreSQL database driver for the DBI module',
    PREREQ_PM	 => { 'Test::Simple' => 0.17 }, # Need Test::More
);

if ($os eq 'hpux') {
    my $osvers = $Config{osvers};
    if ($osvers < 10) {
        print "Warning: Forced to build static not dynamic on $os $osvers.\a\n";
        $opts{LINKTYPE} = 'static';
    }
}

if ($Config{dlsrc} =~ /dl_none/) {
    $opts{LINKTYPE} = 'static';
}

WriteMakefile(%opts);

exit(0);

# end of Makefile.PL
