/*
 * $Source: /opt/cvsroot/erserver/src/com/postgres/replic/server/props/ServerProps.java,v $
 * $Author: ronz $ $Revision: 1.3 $ $Date: 2003/12/29 15:30:17 $
 *
 */

package com.postgres.replic.server.props;

import com.postgres.util.config.*;

import java.util.*;

public class ServerProps extends AbstractProperties {

	// Namespace prefixes to get proper ones from the config file:
	public static final String NS_SERVER = "replic.server.";

	// Property names:
	public static final String REPLIC_INTERVAL = "ReplicInterval";
	public static final String CLEAN_LOG_INTERVAL = "CleanLogInterval";
	public static final String HOW_OLD_LOG = "HowOldLog";
	public static final String SCHEMA = "replic.schema";
	public static final String USE_XID_TYPE = "use_xid_type";
	public static final String PSTMT_REUSE_COUNT = "PstmtReuseCount";

	// Some const:
	private static final int DEF_REPLIC_INTERVAL = 20;
	private static final int DEF_CLEAN_LOG_INTERVAL = 20;
	private static final int DEF_HOW_OLD_LOG = 20;
	private static final int DEF_PSTMT_REUSE_COUNT = 1;

	private boolean verbose;
	private int[] replicIntervals;
	private int howOldLog = T_NO;
	private int cleanInterval = T_NO;
	private int pstmtReuseCount = DEF_PSTMT_REUSE_COUNT;
	private boolean initialized;
	boolean useXID = false;
	String schema = null;


	public ServerProps(ConfiguratorIntf config, boolean debug)
			throws Exception {
		super(config);
		setDebug(debug);
		getReplicIntervals();
		getCleanLogInterval();
		getHowOldLog();
		getPstmtReuseCount();
		//getDebug(debug);
		getVerbose();
		useXIDType();
		getRServSchema();
		initialized = true;
	}

	/*
	*/
	public boolean getDebug() throws Exception {
		if (initialized) {
			return super.getDebug();
		}
		try {
			String sDebug = getConfigurator().getProperty(NS_SERVER +
					"debug");
			if (sDebug == null || sDebug.trim().equals("")) {
				return super.getDebug();
			}
			if (!sDebug.trim().equalsIgnoreCase("true") && !sDebug.trim().equalsIgnoreCase("false")) {
				throw new Exception("Cannot find property or proper value: " + NS_SERVER + "debug");
			} else if (sDebug.trim().equalsIgnoreCase("true")) {
				setDebug(true);
			}

		} catch (Exception e) {
			throw new Exception("ServerProps::getDebug: " + e.toString());
		} finally {

		}
		return super.getDebug();
	}

	/*
	*/
	public boolean getVerbose() throws Exception {
		//System.out.println("### ServerProps::getVerbose initialized="+ verbose);
		if (initialized) {
			return verbose;
		}
		try {
			String sVerbose = getConfigurator().getProperty(NS_SERVER +
					"verbose");
			//System.out.println("### ServerProps::getVerbose key="+ NS_SERVER +
			//    "verbose; value="+sVerbose);
			if (sVerbose == null || sVerbose.trim().equals("")) {
				return verbose;
			}
			if (!sVerbose.trim().equalsIgnoreCase("true") && !sVerbose.trim().equalsIgnoreCase("false")) {
				throw new Exception("Cannot find property or proper value for: " + NS_SERVER + "verbose");
			} else if (sVerbose.trim().equalsIgnoreCase("true")) {
				//System.out.println("### ServerProps::getVerbose return true!");
				verbose = true;
			}

		} catch (Exception e) {
			throw new Exception("ServerProps::getVerbose: " + e.toString());
		} finally {

		}
		return verbose;
	}

	/*
	*/
	public int getCleanLogInterval() throws Exception {
		if (initialized) {
			return cleanInterval;
		}
		try {
			String sCleanInterval = getConfigurator().getProperty(NS_SERVER +
					CLEAN_LOG_INTERVAL);
			if (sCleanInterval == null || sCleanInterval.trim().equals("")) {
				throw new Exception("Cannot find property: " + NS_SERVER + CLEAN_LOG_INTERVAL);
			}
			//String cInterval = null;
			if (sCleanInterval == null) {
				cleanInterval = DEF_CLEAN_LOG_INTERVAL;
			} else {
				cleanInterval = (new Integer(sCleanInterval)).intValue();
				if (cleanInterval < 0) cleanInterval = 0;
			}
			cleanInterval = cleanInterval * 1000;


		} catch (Exception e) {
			throw new Exception("ServerProps::getCleanLogInterval: " + e.toString());
		} finally {

		}
		return cleanInterval;
	}

	/*
	*/
	public int getPstmtReuseCount() throws Exception {
		if (initialized) {
			return pstmtReuseCount;
		}
		try {
			int reuseCount = getConfigurator().getPropertyInt(NS_SERVER +
					PSTMT_REUSE_COUNT);
			pstmtReuseCount = Math.max(reuseCount, DEF_PSTMT_REUSE_COUNT);

		} catch (Exception e) {
			throw new Exception("ServerProps::getPstmtReuseCount: Cannot find property: "
					+ NS_SERVER + PSTMT_REUSE_COUNT + "; " + e.toString());
		} finally {

		}

		return pstmtReuseCount;
	}

	public boolean useXIDType() {

		if (initialized) {
			return useXID;
		}

		try {
			String s = getConfigurator().getProperty(USE_XID_TYPE);
			if (s.equalsIgnoreCase("TRUE")) {
				useXID = true;
				return true;
			}
		} catch (Exception ex) {

		}
		useXID = false;
		return false;
	}


	/*
	*/
	public int getHowOldLog() throws Exception {
		if (initialized) {
			return howOldLog;
		}
		try {
			String sHowOldLog = getConfigurator().getProperty(NS_SERVER +
					HOW_OLD_LOG);
			if (sHowOldLog == null || sHowOldLog.trim().equals("")) {
				throw new Exception("Cannot find property: " + NS_SERVER + HOW_OLD_LOG);
			}

			if (sHowOldLog == null) {
				howOldLog = DEF_HOW_OLD_LOG;
			} else {
				howOldLog = (new Integer(sHowOldLog)).intValue();
				if (howOldLog < 0) howOldLog = DEF_HOW_OLD_LOG;
			}

			howOldLog = howOldLog * 1000;
		} catch (Exception e) {
			throw new Exception("ServerProps::getHowOldLog: " + e.toString());
		} finally {

		}
		return howOldLog;
	}


	/*
	*/
	public int[] getReplicIntervals() throws Exception {
		if (replicIntervals != null) {
			return replicIntervals;
		}

		try {
			getLogger().debug("ServerProps::getReplicIntervals: BEFORE setting ArrayLists");
			ArrayList intervals = getConfigurator().getListProperty(NS_SERVER +
					REPLIC_INTERVAL);
			if (intervals == null || intervals.size() == 0) {
				throw new Exception("Cannot find property: " + NS_SERVER + REPLIC_INTERVAL);
			}

			getLogger().debug("ServerProps::getReplicIntervals: AFTER setting ArrayLists");
			replicIntervals = new int[intervals.size()];
			for (int i = 0; i < intervals.size(); i++) {
				getLogger().debug("ServerProps::getReplicIntervals: in cycle, i=" + i);
				//String rInterval = null;
				if (intervals.get(i) == null) {
					replicIntervals[i] = DEF_REPLIC_INTERVAL;
				} else {
					getLogger().debug("ServerProps::getReplicIntervals: in cycle, intervals.get(i)=" + intervals.get(i));
					replicIntervals[i] = (new Integer((String) intervals.get(i))).intValue();

					if (replicIntervals[i] < 0) replicIntervals[i] = 0;
				}
				replicIntervals[i] = replicIntervals[i] * 1000;
			}
		} catch (Exception e) {
			throw new Exception("ServerProps::getCleanLogInterval: " + e.toString());
		} finally {

		}
		return replicIntervals;
	}

	public void printProperties() {

		String header = "  -- Server General Properties --";
		getLogger().info(header);

		if (replicIntervals != null) {
			for (int i = 0; i < replicIntervals.length; i++) {
				getLogger().info("replicIntervals[" + i + "]=" + replicIntervals[i] + " millis");
			}
		}
		getLogger().info("cleanInterval=" + cleanInterval + " millis");
		getLogger().info("howOldLog=" + howOldLog + " millis");
		getLogger().info("pstmtReuseCount=" + pstmtReuseCount);
		getLogger().info("ers_schema=" + schema);
	}

	public String getRServSchema() {
		if (initialized) {
			return schema;
		}

		/*try {
			String s = getConfigurator().getProperty(SCHEMA);
			if (s != null) {
				schema = s;
				return schema;
			}
		} catch (Exception ex) {

		}*/

		return null;
	}

	public String createRelName(String rel) {
		/*String s = getRServSchema();

		if (s == null) {
			return rel;
		}

		return s+"."+rel;*/
		return rel;
	}
}
