/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.processors;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.stylebook.AbstractComponent;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Engine;
import org.apache.stylebook.Parameters;
import org.apache.stylebook.Processor;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.xml.FormatterToDOM;
import org.apache.xalan.xpath.xml.TreeWalker;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XalanProcessor
extends AbstractComponent
implements Processor {
    private String getStyleSheet(Document document) {
        String string = null;
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            ProcessingInstruction processingInstruction;
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 7 && (processingInstruction = (ProcessingInstruction)node).getNodeName().equals("xml-stylesheet")) {
                boolean bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(processingInstruction.getNodeValue(), " \t=");
                while (stringTokenizer.hasMoreTokens()) {
                    if (!stringTokenizer.nextToken().equals("type")) continue;
                    String string2 = stringTokenizer.nextToken();
                    if ((string2 = string2.substring(1, string2.length() - 1)).equals("text/xsl")) continue;
                    bl = false;
                }
                if (bl) {
                    stringTokenizer = new StringTokenizer(processingInstruction.getNodeValue(), " \t=");
                    while (stringTokenizer.hasMoreTokens()) {
                        if (!stringTokenizer.nextToken().equals("href")) continue;
                        string = stringTokenizer.nextToken();
                        string = string.substring(1, string.length() - 1);
                    }
                    break;
                }
            }
            ++n2;
        }
        return string;
    }

    public Document process(Document document, CreationContext creationContext, Parameters parameters) throws CreationException, IOException {
        try {
            String string;
            Liaison liaison = new Liaison(this.engine);
            XSLTProcessor xSLTProcessor = XSLTProcessorFactory.getProcessor((XMLParserLiaison)liaison);
            xSLTProcessor.setDiagnosticsOutput((OutputStream)System.out);
            Enumeration enumeration = parameters.getParameterNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                xSLTProcessor.setStylesheetParam(string, (XObject)xSLTProcessor.createXString(parameters.getParameter(string)));
            }
            string = parameters.getParameter("stylesheet");
            if (string == null) {
                string = this.getStyleSheet(document);
            }
            if (string == null) {
                return document;
            }
            Document document2 = this.engine.getParser().create();
            Document document3 = this.engine.getParser().parse(new InputSource(string));
            XSLTInputSource xSLTInputSource = new XSLTInputSource((Node)document);
            XSLTInputSource xSLTInputSource2 = new XSLTInputSource((Node)document3);
            xSLTInputSource2.setSystemId(string);
            XSLTResultTarget xSLTResultTarget = new XSLTResultTarget((DocumentHandler)new FormatterToDOM(document2));
            this.log("Applying XSL sheet \"" + string + "\"");
            xSLTProcessor.process(xSLTInputSource, xSLTInputSource2, xSLTResultTarget);
            return document2;
        }
        catch (Exception exception) {
            throw new CreationException(exception.getMessage(), exception, document);
        }
    }

    private class Liaison
    extends XMLParserLiaisonDefault {
        private Engine engine = null;
        private Document document = null;

        public Liaison(Engine engine) {
            this.engine = engine;
        }

        public Document createDocument() {
            return this.engine.getParser().create();
        }

        public Document getDocument() {
            return this.document;
        }

        public void parse(InputSource inputSource) throws IOException, SAXException {
            try {
                this.document = this.engine.getParser().parse(inputSource);
            }
            catch (CreationException creationException) {
                this.engine.debug((Object)this, "CreationException " + creationException.getMessage());
                Exception exception = creationException.getException();
                if (exception == null || !(exception instanceof SAXException)) {
                    throw new SAXException("Exception parsing from Xalan");
                }
                throw (SAXException)exception;
            }
            if (this.m_docHandler != null) {
                new TreeWalker(this.m_docHandler).traverse((Node)this.document);
            }
        }

        public boolean supportsSAX() {
            return false;
        }
    }
}

