#include <iostream>
#include <stdexcept>

#include <pqxx/connection.h>
#include <pqxx/tablereader.h>
#include <pqxx/tablewriter.h>
#include <pqxx/transaction.h>

using namespace std;
using namespace pqxx;


class InsertRows : public Transactor
{
public:
  InsertRows() : Transactor("sample5") {}

  void operator()(argument_type &T)
  {
    T.Exec("INSERT INTO events(year, event) VALUES (2001, 'OSDEM 2001')");

    T.Exec("INSERT INTO events(year, event) VALUES (2001, 'FOSDEM 2002')");

    throw runtime_error("Oops, something goes wrong before we can finish!");

    T.Exec("INSERT INTO events(year, event) VALUES (2001, 'FOSDEM 2003')");
  }

  void OnCommit()
  {
    cout << "Rows inserted successfully." << endl;
  }

  void OnAbort(const char Reason[]) throw ()
  {
    cout << "No rows inserted: " << Reason << endl << endl;
  }
};


int main()
{
  try
  {
    Connection C("");

    C.Perform(InsertRows());
  }
  catch (const exception &e)
  {
    cerr << "Exception: " << e.what() << endl;
    return 1;
  }
  return 0;
}

