#ifndef	pg_config_h_win32__
#define	pg_config_h_win32__
/*
 * Parts of pg_config.h that you get with autoconf on other systems
 */
#define PG_VERSION "7.2"
#define PG_VERSION_STR "7.2 (win32)"

#define SYSCONFDIR ""

#define DEF_PGPORT 5432
#define DEF_PGPORT_STR "5432"

#define MAXIMUM_ALIGNOF 4
#define ACCEPT_TYPE_ARG3 int

#define MAXPGPATH 1024

#define BLCKSZ	8192

#define INDEX_MAX_KEYS		16

#define HAVE_ATEXIT
#define HAVE_MEMMOVE

#define HAVE_CXX_STRING_HEADER
#define HAVE_NAMESPACE_STD

/* use _snprintf instead of snprintf */
#define	HAVE_SNPRINTF_DECL
#define snprintf	_snprintf

/* defines for dynamic linking on Win32 platform */
#ifdef __CYGWIN__

#if __GNUC__ && ! defined (__declspec)
#error You need egcs 1.1 or newer for compiling!
#endif

#ifdef BUILDING_DLL
#define DLLIMPORT __declspec (dllexport)
#else							/* not BUILDING_DLL */
#define DLLIMPORT __declspec (dllimport)
#endif

#elif defined(WIN32) && defined(_MSC_VER)		/* not CYGWIN */

#if defined(_DLL)
#define DLLIMPORT __declspec (dllexport)
#else							/* not _DLL */
#define DLLIMPORT __declspec (dllimport)
#endif

#else							/* not CYGWIN, not MSVC */

#define DLLIMPORT

#endif

#endif /* pg_config_h_win32__ */
