set lScriptFileName [info script]
file lstat $lScriptFileName lFileStats

set lOldDirectory [pwd]

if {($lFileStats(type) == "link")} {
	cd [file dirname [file readlink $lScriptFileName]]
	
} else {
	cd [file dirname $lScriptFileName]
}

set lCurrentDirectory [pwd]
set lDirectoryList [lsort -dictionary [glob -nocomplain *]]

catch {source [file join $lCurrentDirectory "pandora" "source" "init.tcl"]}

foreach lDirectoryName $lDirectoryList {
	if {([file isdirectory $lDirectoryName]) && $lDirectoryName != "pandora" } {
		catch {source [file join $lCurrentDirectory $lDirectoryName "source" "init.tcl"]}
	}
}

foreach lNameSpace [namespace children] {
	if {($lNameSpace != "::tcl") && ($lNameSpace != "::pkg")} {
		catch {namespace import "$lNameSpace\::*"}
	}
}

cd $lOldDirectory
