/*
 * DataPanelToolbar.java
 *
 * Created on 31 de julio de 2002, 18:05
 */

package components.table;
import components.*;
import javax.swing.*;
import java.awt.event.*;

/**
 *
 * @author  nestor
 */
public class DataPanelToolbar extends JToolBar {
    DataPanel panel = null;
    JButton sort = null;
    JButton newRecord = null;
    JButton editRecord = null;
    JButton deleteRecord = null;
    
    /** Creates a new instance of DataPanelToolbar */
    public DataPanelToolbar(DataPanel _panel) {
        panel = _panel;
        
        sort = new JButton(new ImageIcon("images/sort.png"));
        sort.setActionCommand(DataPanelListener.AC_SORT);
        sort.setToolTipText("Sort table");
        sort.addActionListener(panel.getListener());
        this.add(sort);
        
        addSeparator();
        newRecord = new JButton(new ImageIcon("images/new.png"));
        newRecord.setActionCommand(DataPanelListener.AC_NEW);
        newRecord.setToolTipText("New Record");
        newRecord.addActionListener(panel.getListener());
        this.add(newRecord);
        editRecord = new JButton(new ImageIcon("images/edit.png"));
        editRecord.setActionCommand(DataPanelListener.AC_EDIT);
        editRecord.setToolTipText("Edit Record");
        editRecord.addActionListener(panel.getListener());
        this.add(editRecord);
        deleteRecord = new JButton(new ImageIcon("images/delete.png"));
        deleteRecord.setActionCommand(DataPanelListener.AC_DELETE);
        deleteRecord.setToolTipText("Delete Record");
        deleteRecord.addActionListener(panel.getListener());
        this.add(deleteRecord);
        
        this.add(Box.createHorizontalGlue());
    }
    
    public void refreshValidation(){
        if(panel.getTable() != null){
            boolean valid = panel.getTable() != null;
            sort.setEnabled(valid);
            newRecord.setEnabled(valid);
            editRecord.setEnabled(valid);
            deleteRecord.setEnabled(valid);
        }
    }
}
