/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.TreeControlCellRenderer;
import components.TreeControlModel;
import frames.PrincipalFrame;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeSelectionModel;
import pgclibrary.objects.Database;
import pgclibrary.treeObjects.RootElement;
import pgclibrary.treeObjects.TreeInfo;

public class TreeControl
extends JTree {
    private Database database = null;
    private PrincipalFrame frame = null;

    public TreeControl(PrincipalFrame _frame) {
        super(new TreeControlModel(new RootElement(_frame.getDatabase())));
        this.frame = _frame;
        this.database = _frame.getDatabase();
        this.setEditable(false);
        this.setScrollsOnExpand(true);
        this.setShowsRootHandles(true);
        this.putClientProperty("JTree.lineStyle", "Angled");
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        this.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.setCellRenderer(new TreeControlCellRenderer());
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (TreeControl.this.getLastSelectedPathComponent() != null) {
                    TreeInfo tmp = (TreeInfo)TreeControl.this.getLastSelectedPathComponent();
                    TreeControl.this.frame.updateSelectedObject(tmp);
                }
            }
        });
    }

    public TreeInfo getRoot() {
        return (TreeInfo)this.getModel().getRoot();
    }

    public void refreshTree() {
        this.collapseRow(0);
        this.getRoot().refreshProperties();
        TreeControlModel model = (TreeControlModel)this.getModel();
        model.fireTreeStructureChanged();
        this.expandRow(0);
    }
}

