/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.SQLTable;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pgclibrary.dataaccess.dataSource;

public class SQLTableModel
extends AbstractTableModel {
    private SQLTable table = null;
    private dataSource data = null;
    private int column_count = -1;

    public SQLTableModel(SQLTable _table) {
        this.table = _table;
    }

    public int getColumnCount() {
        int retorno = 0;
        if (this.isValid()) {
            retorno = this.data.getColumnCount();
            if (this.column_count > 0 && this.column_count <= retorno) {
                retorno = this.column_count;
            }
        }
        return retorno;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public int getRowCount() {
        int retorno = 0;
        if (this.isValid()) {
            retorno = this.data.getRowCount();
        }
        return retorno;
    }

    public Object getValueAt(int param, int param1) {
        String retorno = new String();
        if (this.isValid()) {
            this.data.moveToRecord(param + 1);
            retorno = this.data.getElementAt(param1 + 1);
        }
        return retorno;
    }

    public String getColumnName(int column) {
        String retorno = new String();
        if (this.isValid()) {
            retorno = (String)this.data.getColumnNames().get(column);
        }
        return retorno;
    }

    public void showColumns(int _column) {
        this.column_count = _column;
    }

    public void setDataSource(dataSource _data) {
        if (this.data != null) {
            this.data.close();
        }
        this.data = _data;
        this.refresh();
    }

    private void refresh() {
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        if (this.data != null) {
            FontMetrics fm = ((Component)this.table).getFontMetrics(this.table.getFont());
            int size = fm.charWidth('O');
            int i = 0;
            while (i < this.data.getColumnCount()) {
                TableColumn tmp = this.table.getColumnModel().getColumn(i);
                int col_size = this.data.getColumnSize(i + 1);
                if (col_size > 30) {
                    col_size = 30;
                }
                tmp.setPreferredWidth(col_size * size);
                ++i;
            }
        }
    }

    public dataSource getDataSource() {
        return this.data;
    }

    private boolean isValid() {
        return this.data != null;
    }
}

