/*
 * dataSourceResultSet.java
 *
 * Created on 14 de septiembre de 2001, 11:16
 */

package pgclibrary.dataaccess;

import java.text.*;
import java.util.*;
import java.sql.*;

/**
 * Establece la implementaci\u00f3n de dataSource para un origen de datos basado en
 * una consulta SQL de la base de datos.
 *
 * @author  NMarsollier
 * @version
 */
public class dataSourceResultSet extends dataSource {
    SimpleDateFormat espFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    
    // Consulta de la base de datos
    String query = new String();
    MainConnection connection = null;
    
    // Registros actuales
    private Statement stat = null;
    private ResultSet rs = null;
    private  boolean eof = false;
    private int row_count = -1;
    
    public dataSourceResultSet() {
    }
    
    public void close(){
        if(rs != null){
            try{
                rs.close();
            } catch (SQLException e){};
            try{
                stat.close();
            } catch (SQLException e){};
        }
    }
    
    protected void finalize()  throws Throwable {
        close();
    }
    
    /** Creates new dataSourceResultSet */
    public dataSourceResultSet(MainConnection _conn, String _query) {
        connection = _conn;
        query = _query;
    }
    
    /** Establece el origen de datos que se utiliza */
    public void setResultSet(MainConnection _conn, String _query)  {
        connection = _conn;
        query = _query;
    }
    
    public void setColumnNames(ArrayList _columnNames){
    }
    public void removeColumnName(String _columnName){
    }
    public void addColumnName(String _columnName){
    }
    
    public void goTop(){
        if(rs == null){
            requeryInternal();
        }
        try {
            rs.beforeFirst();
        } catch (Exception e) {}
        setRowNum(0);
        eof = false;
    }
    
    public boolean next(){
        if(rs == null){
            requeryInternal();
        }
        boolean retorno = false;
        if (rs != null){
            try {
                retorno = rs.next();
                setRowNum(getRowNum()+1);
            } catch (Exception e) {}
        }
        if(!retorno){
            eof = true;
        }
        return retorno;
    }
    
    public boolean eof(){
        if(rs == null){
            requeryInternal();
        }
        return eof;
    }
    
    public String getElementAt(int _col){
        String resultado = new String();
        if(rs == null){
            requeryInternal();
        }
        
        try{
            ResultSetMetaData rsmd = rs.getMetaData();
            switch (rsmd.getColumnType(_col)){
                case java.sql.Types.DATE:
                case java.sql.Types.TIMESTAMP:
                    java.sql.Timestamp tmp = rs.getTimestamp(_col);
                    if(tmp != null){
                        resultado = espFormat.format(tmp);
                    }
                    break;
                default: resultado = rs.getString(_col);
            }
        } catch (SQLException e) {}
        return resultado;
    }
    
    public int getColumnCount(){
        if(rs == null){
            requeryInternal();
        }
        return getColumnNames().size();
    }
    
    public int getColumnSize(int _col){
        int retorno = 10;
        try{
            ResultSetMetaData rsmd = rs.getMetaData();
            retorno = rsmd.getColumnDisplaySize(_col);
        } catch (SQLException e) {}
        
        return validateColumnSize(retorno);
    }
    
    public int getRowCount(){
        if(rs == null){
            requeryInternal();
        }
        if(row_count == -1){
            String query1= "SELECT COUNT(*) AS CANT FROM ( "
                         + query + ") as tmp ";
            try {
                MainConnection tmp = new MainConnection(connection);
                ResultSet rscant = tmp.executeQuery(query1);
                if((rscant != null) && rscant.next()){
                    row_count = rscant.getInt("CANT");
                }
                rscant.close();
                tmp.close();
            } catch (SQLException e){}
        }
        return row_count;
    }
    
    /** Filtra la consulta en base a los numeros de registros que se pasan
     *  solamente muestra los registros entre esos rangos
     */
    public void setDataFilterRecord(int _rec_begin, int _rec_end){
        super.setDataFilterRecord(_rec_begin, _rec_end);
        requeryInternal();
    }
    
    public void requery() throws SQLException {
        close();
        if (isFiltered()){
            String query1 = query + " limit " + String.valueOf(getRowEnd() -getRowBegin());
            query1 = query1 + " offset " + String.valueOf(getRowBegin());
            stat = connection.getStatement();
            rs = stat.executeQuery(query1);
        } else {
            stat = connection.getStatement();
            rs = stat.executeQuery(query);
        }
        row_count = -1;
        setAllColumnNames();
    }
    private void requeryInternal(){
        try{
            requery();
        } catch (SQLException e){}
    }
    
    private void setAllColumnNames(){
        try{
            ResultSetMetaData rsmd = rs.getMetaData();
            super.getColumnNames().clear();
            int columnas = rsmd.getColumnCount();
            for(int i=0; i<columnas ; i++){
                super.addColumnName(rsmd.getColumnName(i+1));
            }
            goTop();
        } catch (SQLException e){}
    }
}
