/*
 * AttributeTypes.java
 *
 * Created on 31 de julio de 2002, 09:14
 */

package pgclibrary.objects;
import java.util.*;
import java.sql.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class AttributeType {
    private long oid = 0;
    private String name = new String();
    private int size = -1;
    protected static Vector instances = new Vector();
    
    /** Creates a new instance of AttributeType */
    private AttributeType() {
    }
    
    public boolean search(long _oid){
        boolean retorno = false;
        try{
            PreparedStatement prep = Database.getMainConnection().prepareStatement("select OID, * "
            + " from pg_type where oid = ?");
            prep.setLong(1, _oid);
            ResultSet rs = prep.executeQuery();
            if(rs.next()){
                oid = rs.getLong("OID");
                setName(rs.getString("TYPNAME"));
                size = rs.getInt("TYPLEN");
                retorno = true;
            }
    } catch (Exception e){
            e.printStackTrace();
        }
        return retorno;
    }
    
    public long getOID(){
        return oid;
    }
    private void setName(String _name){
        if(_name != null){
            name = _name;
        } else {
            name = new String();
        }
    }
    public String getName(){
        return name;
    }
    public int getSize(){
        return size;
    }
    
    public long getSQLType() {
        switch ((int) oid) {
            case 16: 
            case 1560: 
                return Types.BIT;
            case 20: 
            case 21: 
            case 22: 
            case 23: 
                return Types.INTEGER;
            case 1700: 
            case 790: 
            case 701: 
            case 700: 
                return Types.DOUBLE;
            case 18: 
            case 25: 
            case 1042: 
            case 1043: 
                return Types.CHAR;
            case 1082: 
                return Types.DATE;
            case 1083: 
                return Types.TIME;
            case 1084: 
                return Types.TIMESTAMP;
        }
        System.out.println(getName() + " - " + oid);
        return -1*oid;
    }
    
    public static AttributeType getInstance(long oid){
        AttributeType retorno = null;
        for(int i=0; (i < instances.size()) && (retorno == null); i++){
            AttributeType tmp = (AttributeType) instances.get(i);
            if(tmp.getOID() == oid){
                retorno = tmp;
            }
        }
        return retorno;
    }
    public static void addInstance(AttributeType _column){
        if ((_column != null) && (getInstance(_column.getOID()) == null)){
            instances.add(_column);
        }
    }
    
    public static AttributeType searchObject(long oid){
        AttributeType retorno = getInstance(oid);
        
        if(retorno == null){
            retorno = new AttributeType();
            if(retorno.search(oid)){
                addInstance(retorno);
            } else {
                System.out.println("Atribute type not found");
                retorno = null;
            }
        }
        return retorno;
    }
}
