/*
 * Decompiled with CFR 0.152.
 */
package components.table;

import components.SQLTable;
import components.SQLTableModel;
import components.table.IndexPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pgclibrary.dataaccess.dataSource;
import pgclibrary.dataaccess.dataSourceVector;
import pgclibrary.objects.Table;
import pgclibrary.objects.TableIndex;
import pgclibrary.utilities.Utilities;

public class IndexPanel
extends JPanel {
    private Table table = null;
    private SQLTable data_table = new SQLTable();
    private IndexPanelListener listener = new IndexPanelListener(this);

    public IndexPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SQLTableModel sQLTableModel = new SQLTableModel(this.data_table);
        this.data_table.setModel(sQLTableModel);
        this.add((Component)new JScrollPane(this.data_table), "Center");
    }

    public void refresh() {
        ((SQLTableModel)this.data_table.getModel()).setDataSource(this.getIndexTable());
        this.repaint();
    }

    public void refresh(Table table) {
        this.table = table;
        this.refresh();
    }

    public Table getTable() {
        return this.table;
    }

    public IndexPanelListener getListener() {
        return this.listener;
    }

    public void newIndex() {
    }

    public void editIndex() {
    }

    public void deleteIndex() {
    }

    private dataSource getIndexTable() {
        dataSourceVector dataSourceVector2 = new dataSourceVector();
        dataSourceVector2.addColumnName("Name");
        dataSourceVector2.addColumnName("Primary");
        dataSourceVector2.addColumnName("Unique");
        dataSourceVector2.addColumnName("Cluster");
        dataSourceVector2.addColumnName("Columns");
        dataSourceVector2.addColumnSize(20);
        dataSourceVector2.addColumnSize(6);
        dataSourceVector2.addColumnSize(6);
        dataSourceVector2.addColumnSize(6);
        dataSourceVector2.addColumnSize(30);
        if (this.table != null) {
            Vector vector = this.table.getIndexes();
            int n = 0;
            while (n < vector.size()) {
                TableIndex tableIndex = (TableIndex)vector.get(n);
                Vector<String> vector2 = new Vector<String>();
                vector2.add(tableIndex.getName());
                vector2.add(Utilities.formatBoolean(tableIndex.isPrimary()));
                vector2.add(Utilities.formatBoolean(tableIndex.isUnique()));
                vector2.add(Utilities.formatBoolean(tableIndex.isClustered()));
                vector2.add(tableIndex.getColumnsText());
                dataSourceVector2.addElement(vector2);
                ++n;
            }
        }
        return dataSourceVector2;
    }
}

