/*
 * Decompiled with CFR 0.152.
 */
package components.table;

import components.table.TableAddRecordDialogListener;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import pgclibrary.objects.Table;
import pgclibrary.objects.TableColumn;
import pgclibrary.utilities.SUtilities;

public class TableAddRecordDialog
extends JDialog {
    Table table = null;
    Vector columns = new Vector();

    public TableAddRecordDialog(Table table) {
        this.setTitle("Add record: - " + table.getName());
        this.table = table;
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TableAddRecordDialog.this.close();
            }
        });
        this.getContentPane().add(this.getContents(), "Center");
        this.getContentPane().add(this.getButtons(), "South");
        this.setModal(true);
        this.pack();
    }

    private Component getContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        int n = 0;
        while (n < this.table.getColumns().size()) {
            TableColumn tableColumn = (TableColumn)this.table.getColumns().get(n);
            JTextComponent jTextComponent = null;
            if (tableColumn.getSize() < 40) {
                jTextComponent = new JTextField(20);
                jPanel.add(SUtilities.getHorPanel(tableColumn.getName().toUpperCase() + " :", jTextComponent));
            } else {
                jTextComponent = new JTextArea(3, 20);
                JScrollPane jScrollPane = new JScrollPane(jTextComponent);
                jScrollPane.setPreferredSize(jTextComponent.getPreferredSize());
                jScrollPane.setAutoscrolls(false);
                jPanel.add(SUtilities.getHorPanel(tableColumn.getName().toUpperCase() + " :", jScrollPane));
            }
            this.columns.add(jTextComponent);
            ++n;
        }
        return jPanel;
    }

    private Component getButtons() {
        TableAddRecordDialogListener tableAddRecordDialogListener = new TableAddRecordDialogListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        JButton jButton = new JButton("Insert");
        jButton.setActionCommand("insert");
        jButton.addActionListener(tableAddRecordDialogListener);
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(5));
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel");
        jButton2.addActionListener(tableAddRecordDialogListener);
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    protected void insert() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.columns.size()) {
            JTextComponent jTextComponent = (JTextComponent)this.columns.get(n);
            vector.add(jTextComponent.getText());
            ++n;
        }
        try {
            this.table.insertRecord(vector);
            this.dispose();
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(this, sQLException.getMessage(), "Message", 1);
        }
    }

    protected void close() {
        this.dispose();
    }
}

