/*
 * Decompiled with CFR 0.152.
 */
package components.view;

import components.view.ColumnPanel;
import components.view.DataPanel;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pgclibrary.objects.View;
import pgclibrary.utilities.SUtilities;

public class ViewPanel
extends JTabbedPane {
    View view_object = null;
    JTextField name = new JTextField(20);
    JTextField owner = new JTextField(20);
    JTextArea description = new JTextArea(3, 20);
    DataPanel data_panel = new DataPanel();
    ColumnPanel column_panel = new ColumnPanel();
    JTextArea sql = new JTextArea();

    public ViewPanel() {
        this.initPanel();
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setView(View view) {
        this.view_object = view;
        this.refreshProperties();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.insertDefaultTab();
        this.addTab("Columns", this.column_panel);
        this.addTab("Data", this.data_panel);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ViewPanel.this.refreshProperties();
            }
        });
    }

    public void refreshProperties() {
        switch (this.getSelectedIndex()) {
            case 0: {
                this.refreshDefaultPanel();
                break;
            }
            case 1: {
                this.column_panel.refresh(this.view_object);
                break;
            }
            case 2: {
                this.data_panel.refresh(this.view_object);
            }
        }
    }

    private void insertDefaultTab() {
        this.name.setEditable(false);
        this.owner.setEditable(false);
        this.description.setEditable(false);
        this.description.setBorder(this.owner.getBorder());
        this.description.setBackground(this.owner.getBackground());
        this.description.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.description);
        jScrollPane.setPreferredSize(this.description.getPreferredSize());
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        this.sql.setEditable(false);
        this.sql.setLineWrap(true);
        jSplitPane.setBottomComponent(new JScrollPane(this.sql));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(SUtilities.getHorPanel("View Name :", this.name));
        jPanel.add(SUtilities.getHorPanel("View Owner :", this.owner));
        jPanel.add(SUtilities.getHorPanel("Description :", jScrollPane));
        jSplitPane.setTopComponent(SUtilities.centerComponent(jPanel));
        this.addTab("General", jSplitPane);
    }

    private void refreshDefaultPanel() {
        this.name.setText(this.view_object.getName());
        this.owner.setText(this.view_object.getCreator().getName());
        this.sql.setText(this.view_object.getInsertSQL());
        this.description.setText(this.view_object.getDescription());
        this.repaint();
    }
}

