/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.dataaccess;

import java.util.AbstractCollection;
import java.util.ArrayList;

public abstract class dataSource {
    public static final int MAX_COLUMN_SIZE = 100;
    public static final int MIN_COLUMN_SIZE = 7;
    public static final int DEFAULT_COLUMN_SIZE = 12;
    private ArrayList columnNames = new ArrayList();
    private int rowNum = 0;
    private boolean filtered = false;
    private int rec_begin;
    private int rec_end;

    public abstract void close();

    public abstract void goTop();

    public void moveToRecord(int n) {
        if (n < this.getRowNum()) {
            this.goTop();
        }
        while (this.getRowNum() < n) {
            this.next();
        }
    }

    public abstract boolean next();

    public abstract boolean eof();

    public abstract int getColumnCount();

    public int getColumnSize(String string) {
        if (string != null) {
            return this.getColumnSize(this.columnNames.indexOf(string.toUpperCase()) + 1);
        }
        return 10;
    }

    public abstract int getColumnSize(int var1);

    protected int validateColumnSize(int n) {
        if (n > 100) {
            n = 100;
        } else if (n < 1) {
            n = 12;
        } else if (n < 7) {
            n = 7;
        }
        return n;
    }

    public abstract String getElementAt(int var1);

    public abstract int getRowCount();

    public void setDataFilterRecord(int n, int n2) {
        this.filtered = true;
        this.rec_begin = n;
        this.rec_end = n2;
    }

    public int getRowBegin() {
        return this.rec_begin;
    }

    public int getRowEnd() {
        return this.rec_end;
    }

    public void clearFilters() {
        if (this.isFiltered()) {
            this.filtered = false;
        }
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    protected void setRowNum(int n) {
        if (n < 0) {
            n = 0;
        }
        this.rowNum = n;
    }

    public String getElementAt(String string) {
        if (string != null) {
            return this.getElementAt(this.columnNames.indexOf(string.toUpperCase()) + 1);
        }
        return "null";
    }

    public int getIntAt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(this.getElementAt(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public int getIntAt(int n) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(this.getElementAt(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public double getDoubleAt(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.getElementAt(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double getDoubleAt(int n) {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.getElementAt(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void setColumnNames(ArrayList arrayList) {
        this.columnNames.clear();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                this.columnNames.add(arrayList.get(n));
                ++n;
            }
        }
    }

    public ArrayList getColumnNames() {
        return this.columnNames;
    }

    public void addColumnName(String string) {
        if (string != null && this.columnNames.indexOf(string) < 0) {
            this.columnNames.add(string.toUpperCase());
        }
    }

    public void removeColumnName(String string) {
        if (string != null) {
            ((AbstractCollection)this.columnNames).remove(string);
        }
    }

    public boolean find(int n, String string) {
        boolean bl = false;
        this.goTop();
        while (!bl && this.next()) {
            bl = this.getElementAt(n).equals(string);
        }
        return bl;
    }
}

