/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.User;

public class Sequence
extends DBObject {
    private long last_value = 0L;
    private long increment_by = 0L;
    private long max_value = 0L;
    private long min_value = 0L;
    private long cache_value = 0L;
    private boolean cycled = false;
    private boolean called = false;
    private long start = 0L;
    private String description = null;

    public Sequence(DBObject dBObject, String string) {
        super(dBObject);
        this.search(string);
    }

    public Sequence(DBObject dBObject) {
        super(dBObject);
    }

    public boolean Drop() {
        boolean bl = false;
        try {
            bl = this.getConnection().executeUpdate("DROP SEQUENCE " + this.getName()) > 0;
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, sQLException.getMessage(), "Can't drop object", 0);
        }
        return bl;
    }

    public String getDeleteSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP SEQUENCE ");
        stringBuffer.append(this.getName()).append(";\n");
        return stringBuffer.toString();
    }

    public String getInsertSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE SEQUENCE ");
        stringBuffer.append(this.getName()).append(" ");
        if (this.getIncrementBy() > 1L) {
            stringBuffer.append("\n\tINCREMENT ").append(this.getIncrementBy()).append(" ");
        }
        if (this.getMinValue() > 0L) {
            stringBuffer.append("\n\tMINVALUE ").append(this.getMinValue()).append(" ");
        }
        if (this.getMaxValue() > 0L) {
            stringBuffer.append("\n\tMAXVALUE ").append(this.getMaxValue()).append(" ");
        }
        if (this.getStart() > 0L) {
            stringBuffer.append("\n\tSTART ").append(this.getStart()).append(" ");
        }
        if (this.getCacheValue() > 0L) {
            stringBuffer.append("\n\tCACHE ").append(this.getCacheValue()).append(" ");
        }
        if (this.isCycled()) {
            stringBuffer.append("\n\tCYCLE ");
        }
        stringBuffer.append(";\n");
        stringBuffer.append(this.getCommentSQL());
        return stringBuffer.toString();
    }

    public boolean search(String string) {
        boolean bl = false;
        try {
            this.initialize();
            ResultSet resultSet = this.getConnection().getQueryGenerator().getSequence(string);
            if (resultSet != null && resultSet.next()) {
                this.setName(resultSet.getString("sequence_name"));
                this.setCreator(new User((DBObject)this, resultSet.getString("sequence_owner")));
                this.setLastValue(resultSet.getLong("last_value"));
                this.setIncrementBy(resultSet.getLong("increment_by"));
                this.setMaxValue(resultSet.getLong("max_value"));
                this.setMinValue(resultSet.getLong("min_value"));
                this.setCacheValue(resultSet.getLong("cache_value"));
                this.setCycled(resultSet.getBoolean("is_cycled"));
                this.setCalled(resultSet.getBoolean("is_called"));
                bl = true;
            }
            resultSet.close();
            resultSet.getStatement().close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.initialize();
        }
        return bl;
    }

    public void initialize() {
        super.initialize();
        this.start = 0L;
        this.last_value = 0L;
        this.increment_by = 0L;
        this.max_value = 0L;
        this.min_value = 0L;
        this.cache_value = 0L;
        this.cycled = false;
        this.called = false;
        this.description = null;
    }

    public long getLastValue() {
        return this.last_value;
    }

    public long getIncrementBy() {
        return this.increment_by;
    }

    public long getMaxValue() {
        return this.max_value;
    }

    public long getMinValue() {
        return this.min_value;
    }

    public long getCacheValue() {
        return this.cache_value;
    }

    public boolean isCycled() {
        return this.cycled;
    }

    public boolean isCalled() {
        return this.called;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getConnection().getQueryGenerator().getTableDescription(this.getName());
        }
        return this.description;
    }

    public void refresh() {
        this.search(this.getName());
    }

    private void setLastValue(long l) {
        this.last_value = l;
    }

    private void setIncrementBy(long l) {
        this.increment_by = l;
    }

    private void setMaxValue(long l) {
        this.max_value = l;
    }

    private void setMinValue(long l) {
        this.min_value = l;
    }

    private void setCacheValue(long l) {
        this.cache_value = l;
    }

    private void setCycled(boolean bl) {
        this.cycled = bl;
    }

    private void setCalled(boolean bl) {
        this.called = bl;
    }

    private long getStart() {
        return this.start;
    }

    private void setStart(long l) {
        this.start = l;
    }

    private String getCommentSQL() {
        String string = new String();
        if (this.getDescription().length() > 0) {
            string = "COMMENT ON SEQUENCE " + this.getName() + " IS '" + this.getDescription() + "'; \n";
        }
        return string;
    }

    private void setDescription(String string) {
        this.description = string != null ? string : new String();
    }
}

