/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JOptionPane;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.TableColumn;
import pgclibrary.objects.User;
import pgclibrary.utilities.Utilities;

public class View
extends DBObject {
    private String definition = new String();
    private Vector columns = null;
    private String description = null;

    public View(DBObject dBObject, String string) {
        super(dBObject);
        this.search(string);
    }

    public View(DBObject dBObject) {
        super(dBObject);
    }

    public boolean Drop() {
        boolean bl = false;
        try {
            bl = this.getConnection().executeUpdate("DROP VIEW " + this.getName()) > 0;
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, sQLException.getMessage(), "Can't drop object", 0);
        }
        return bl;
    }

    public String getDeleteSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP VIEW ");
        stringBuffer.append(this.getName());
        stringBuffer.append(";\n ");
        return stringBuffer.toString();
    }

    public String getInsertSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE VIEW ").append(this.getName()).append(" AS ");
        stringBuffer.append(this.definition);
        stringBuffer.append(";\n");
        stringBuffer.append(this.getCommentSQL());
        int n = 0;
        while (n > this.getColumns().size()) {
            TableColumn tableColumn = (TableColumn)this.getColumns().get(n);
            stringBuffer.append(tableColumn.getCommentSQL());
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean search(String string) {
        boolean bl = false;
        try {
            this.initialize();
            ResultSet resultSet = this.getConnection().getQueryGenerator().getView(string);
            if (resultSet != null && resultSet.next()) {
                this.setName(resultSet.getString("view_name"));
                this.setCreator(new User((DBObject)this, resultSet.getString("view_owner")));
                this.setDefinition(resultSet.getString("view_definition"));
                bl = true;
            }
            resultSet.close();
            resultSet.getStatement().close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return bl;
    }

    public void initialize() {
        super.initialize();
        this.definition = new String();
        this.columns = null;
        this.description = null;
    }

    public Vector getColumns() {
        if (this.columns == null) {
            this.columns = new Vector();
            try {
                ResultSet resultSet = this.getConnection().getQueryGenerator().getColumnNames(this.getName());
                while (resultSet != null && resultSet.next()) {
                    this.columns.add(new TableColumn(this, resultSet.getString("column_name")));
                }
                resultSet.close();
                resultSet.getStatement().close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        return this.columns;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getConnection().getQueryGenerator().getTableDescription(this.getName());
        }
        return this.description;
    }

    public void refresh() {
        this.search(this.getName());
    }

    private void setDefinition(String string) {
        if (string != null) {
            string = Utilities.replaceAll(string, "SELECT", "\n\tSELECT");
            string = Utilities.replaceAll(string, "FROM", "\n\tFROM");
            string = Utilities.replaceAll(string, "WHERE", "\n\tWHERE");
            string = Utilities.replaceAll(string, "ORDER", "\n\tORDER");
            this.definition = string = Utilities.replaceAll(string, "UNION", "\nUNION");
        } else {
            this.definition = new String();
        }
    }

    private String getDefinition() {
        return this.definition;
    }

    private String getCommentSQL() {
        String string = new String();
        if (this.getDescription().length() > 0) {
            string = "COMMENT ON VIEW " + this.getName() + " IS '" + this.getDescription() + "'; \n";
        }
        return string;
    }

    private void setDescription(String string) {
        this.description = string != null ? string : new String();
    }
}

