/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.utilities;

import javax.swing.JTextPane;
import pgclibrary.utilities.Utilities;

public class SQLTextParser {
    private JTextPane text = null;
    private int last_offset_read = 0;
    private int _start_off = 0;
    private int _end_off = 0;

    public SQLTextParser(JTextPane jTextPane) {
        this.text = jTextPane;
    }

    public String getCommand(int n) {
        return this.getParagraph(n);
    }

    public String getNextCommand() {
        String string = new String();
        while (string.length() == 0 && this.last_offset_read < this._end_off) {
            string = this.getParagraph(this.last_offset_read + 2);
        }
        return string;
    }

    public String getFirstCommand() {
        return this.getParagraph(0);
    }

    private String getParagraph(int n) {
        this._start_off = this.text.getDocument().getStartPosition().getOffset();
        this._end_off = this.text.getDocument().getEndPosition().getOffset() - 1;
        String string = new String();
        if (n < this._end_off + 1 && n >= this._start_off) {
            int n2 = this.getParagraphStartOffset(n);
            this.last_offset_read = this.getParagraphEndOffset(n);
            try {
                string = this.text.getDocument().getText(n2, this.last_offset_read - n2);
            }
            catch (Exception exception) {
                string = new String();
            }
            string = Utilities.replaceAll(string, "\n", " ");
            string = Utilities.replaceAll(string, "\t", " ");
            string = string.trim();
            if (string.length() > 0 && string.charAt(string.length() - 1) == ';') {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() > 0 && string.charAt(0) == ';') {
                string = string.substring(1, string.length());
            }
            string = string.trim();
        }
        return string;
    }

    private int getParagraphStartOffset(int n) {
        int n2 = n;
        if (n2 <= this._start_off) {
            n2 = this._start_off + 1;
        }
        boolean bl = false;
        while (!bl && --n2 > this._start_off) {
            try {
                if (!this.text.getDocument().getText(n2, 1).equals("\n")) continue;
                String string = this.getPrevChar(n2);
                bl = string == null || string.equals("\n") || string.equals(";");
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        return n2;
    }

    private int getParagraphEndOffset(int n) {
        int n2 = n - 1;
        boolean bl = false;
        while (!bl && ++n2 <= this._end_off) {
            try {
                if (!this.text.getDocument().getText(n2, 1).equals("\n")) continue;
                String string = this.getPrevChar(n2);
                bl = string == null || string.equals("\n") || string.equals(";");
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        return n2;
    }

    private String getPrevChar(int n) {
        String string = null;
        try {
            --n;
            while (n >= this._start_off && this.text.getDocument().getText(n, 1).equals(" ")) {
                --n;
            }
            if (n >= this._start_off) {
                string = this.text.getDocument().getText(n, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

