/*
 * TreeToolbar.java
 *
 * Created on 19 de julio de 2002, 10:28
 */

package components;
import frames.*;
import components.treeObjects.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 *
 * @author  nestor
 */
public class TreeToolbar extends JToolBar{
    JButton new_object = null;
    JButton delete_object = null;
    JButton edit_object = null;
    
    PrincipalFrameComponent frame = null;
    
    /** Creates a new instance of TreeToolbar */
    public TreeToolbar(PrincipalFrameComponent _frame){
        frame = _frame;
        
        new_object = new JButton(new ImageIcon(getClass().getResource("/images/new.png")));
        new_object.setActionCommand(TreeListener.AC_NEW_OBJECT);
        new_object.setToolTipText("New Object");
        new_object.addActionListener(frame.getListener());
//        add(new_object);
        
        edit_object = new JButton(new ImageIcon(getClass().getResource("/images/edit.png")));
        edit_object.setActionCommand(TreeListener.AC_EDIT_OBJECT);
        edit_object.setToolTipText("Edit Object");
        edit_object.addActionListener(frame.getListener());
//        add(edit_object);
        
        delete_object = new JButton(new ImageIcon(getClass().getResource("/images/delete.png")));
        delete_object.setActionCommand(TreeListener.AC_DELETE_OBJECT);
        delete_object.setToolTipText("Delete Object");
        delete_object.addActionListener(frame.getListener());
        add(delete_object);
    }
    
    public void  refreshValidation(){
        if(frame != null){
            boolean valid = (frame.getLastSelected() != null) ;
            
            new_object.setEnabled(valid
                && (frame.getLastSelected().getClass() != Element.class)
                && (frame.getLastSelected().getClass() != RootElement.class)) ;
            delete_object.setEnabled(valid && (frame.getLastSelected().getClass() == Element.class) );
            edit_object.setEnabled(valid && (frame.getLastSelected().getClass() == Element.class) );
        }
    }
}
