/*
 * TableAddRecord.java
 *
 * Created on 7 de agosto de 2002, 11:06
 */

package components.table;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import pgclibrary.dataaccess.*;
import pgclibrary.objects.*;
import pgclibrary.utilities.*;
import java.util.*;
import java.sql.*;

/**
 *
 * @author  nestor
 */
public class TableAddRecordDialog extends JDialog {
    Table table = null;
    Vector columns = new Vector();
    
    /** Creates a new instance of TableAddRecord */
    public TableAddRecordDialog(Table _table) {
        this.setTitle("Add record:" + " - " + _table.getName());
        table = _table;
        
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        
        addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e) {
                close();
            }});
            
            getContentPane().add(getContents(), BorderLayout.CENTER);
            getContentPane().add(getButtons(), BorderLayout.SOUTH);
            
            setModal(true);
            pack();
    }
    
    
    private Component getContents(){
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        panel.setBorder(BorderFactory.createEmptyBorder(20,20,20,20));
        
        for(int i= 0; i<table.getColumns().size(); i++){
            TableColumn tc = (TableColumn) table.getColumns().get(i);
            
            JTextComponent tf = null;
            if(tc.getSize() < 40){
                tf = new JTextField(20);
                panel.add(SUtilities.getHorPanel(tc.getName().toUpperCase() + " :", tf));
            } else {
                tf = new JTextArea(3,20);
                JScrollPane jsp = new JScrollPane(tf);
                jsp.setPreferredSize(tf.getPreferredSize());
                jsp.setAutoscrolls(false);
                panel.add(SUtilities.getHorPanel(tc.getName().toUpperCase() + " :", jsp));
            }
            columns.add(tf);
        }
        return panel;
    }
    
    private Component getButtons(){
        TableAddRecordDialogListener listener = new TableAddRecordDialogListener(this);
        
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
        
        panel.add(Box.createHorizontalGlue());
        
        JButton okey = new JButton("Insert");
        okey.setActionCommand(TableAddRecordDialogListener.AC_INSERT);
        okey.addActionListener(listener);
        panel.add(okey);
        
        panel.add(Box.createHorizontalStrut(5));
        
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand(TableAddRecordDialogListener.AC_CANCEL);
        cancel.addActionListener(listener);
        panel.add(cancel);
        
        panel.add(Box.createHorizontalGlue());
        
        return panel;
    }
    
    protected void insert(){
        Vector data = new Vector();
        for(int i=0; i<columns.size(); i++){
            JTextComponent tc = (JTextComponent) columns.get(i);
            data.add(tc.getText());
        }
        try {
            table.insertRecord(data);
            dispose();
        } catch (SQLException e){
            JOptionPane.showMessageDialog(this, e.getMessage() , "Message", JOptionPane.INFORMATION_MESSAGE);
        }
    }
    protected void close(){
        dispose();
    }
}

class TableAddRecordDialogListener implements ActionListener {
    public static final String AC_CANCEL = "cancel";
    public static final String AC_INSERT = "insert";
    
    private TableAddRecordDialog frame = null;
    
    /** Creates a new instance of PrincipalFrame_listener */
    public TableAddRecordDialogListener(TableAddRecordDialog _frame){
        frame = _frame;
    }
    
    public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
        if(actionEvent.getActionCommand().equals(AC_CANCEL)){
            frame.close();
        }
        if(actionEvent.getActionCommand().equals(AC_INSERT)){
            frame.insert();
        }
    }
}


