/*
 * ColumnPanel.java
 *
 * Created on 1 de agosto de 2002, 16:34
 */

package components.view;
import components.*;
import javax.swing.*;
import java.awt.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class ColumnPanel extends JPanel {
    private View view = null;
    private SQLTable data_view = new SQLTable();
    
    /** Creates a new instance of ColumnPanel */
    public ColumnPanel() {
        data_view = new SQLTable();
        initPanel();
    }
    
    private void initPanel(){
        setLayout(new BorderLayout());
        setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        
        
        SQLTableModel sql_tm = new SQLTableModel(data_view);
        data_view.setModel(sql_tm);
        
        add(new JScrollPane(data_view), BorderLayout.CENTER);
    }
    public void refresh(){
        ((SQLTableModel) data_view.getModel()).setDataSource(getColumnsTable());
        repaint();
    }
    public void refresh(View view_object){
        view = view_object;
        refresh();
    }
    
    public View getView(){
        return view;
    }
    
    public void newColumn(){
    }
    public void editColumn(){
    }
    public void deleteColumn(){
    }
    
    public dataSource getColumnsTable(){
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Col #");
        dsve.addColumnName("Name");
        dsve.addColumnName("Type");
        dsve.addColumnName("Size");
        dsve.addColumnName("Nulls");
        dsve.addColumnName("Description");
        dsve.addColumnSize(10);
        dsve.addColumnSize(20);
        dsve.addColumnSize(15);
        dsve.addColumnSize(5);
        dsve.addColumnSize(5);
        dsve.addColumnSize(30);
        
        if(view != null){
            Vector temp = view.getColumns();
            for(int i=0; i<temp.size(); i++){
                TableColumn tc = (TableColumn) temp.get(i);
                Vector elem = new Vector();
                elem.add(String.valueOf(tc.getColumnNumber()));
                elem.add(tc.getName());
                elem.add(tc.getColumnType().getName());
                elem.add(String.valueOf(tc.getSize()));
                elem.add(Utilities.formatBoolean(tc.allowNulls()));
                elem.add(tc.getDescription());
                
                dsve.addElement(elem);
            }
        }
        return dsve;
    }
}

