/*
 * DatabaseQuerys_7_2.java
 *
 * Created on 14 de agosto de 2002, 11:54
 */

package pgclibrary.dataaccess;
import java.sql.*;

/**
 *
 * @author  nestor
 */
public class DatabaseQuerys_7_2 extends DatabaseQuerys_7_1 {

    /** Creates a new instance of DatabaseQuerys_7_2 */
    public DatabaseQuerys_7_2(MainConnection _connection) {
        super(_connection);
    }


    public String getColumnDescription(String _tableName, String _columnName){
        String retorno = new String();

        try{
            PreparedStatement prep = connection.prepareStatement("select "
            + " col_description(attrelid, attnum) as description "
            + " from pg_attribute, pg_class "
            + " where pg_class.oid = pg_attribute.attrelid and relname=? and attname=? ");
            prep.setString(1, _tableName);
            prep.setString(2, _columnName);
            ResultSet rs = prep.executeQuery();
            if ((rs != null) && (rs.next())){
                if(rs.getString("description") != null) {
                    retorno = rs.getString("description");
                }
            }
            rs.close();
            prep.close();
        } catch (SQLException e){
            e.printStackTrace();
        }
        return retorno;
    }

    public String getTableDescription(String _tableName){
        String retorno = new String();

        try{
            PreparedStatement prep = connection.prepareStatement("select "
             + " obj_description(oid, relname) as description "
             + " from pg_class where relname=? ");
            prep.setString(1, _tableName);
            ResultSet rs = prep.executeQuery();
            
            if ((rs != null) && (rs.next())){
                if (rs.getString("description") != null){
                    retorno = rs.getString("description");
                }
            }
            
            rs.close();
            prep.close();
        } catch (SQLException e){
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getIndex(String _name)
    {
        ResultSet retorno = null;
        try
        {
            PreparedStatement prep = connection.prepareStatement("select "
            + " relname as index_name, indisclustered as index_cluster, "
            + " indisunique as index_unique, "
            + " indisprimary as index_primary "
            + " from pg_index, pg_class "
            + " where pg_class.oid = indexrelid and relname = ? ");
            prep.setString(1, _name);
            retorno = prep.executeQuery();
        }
        catch (SQLException e)
        {
            e.printStackTrace();
        }
        return retorno;
    }

}
