/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "applicationsettings.h"
#include "../utils/xmlutils.h"
#include "../utils/debugger.h"

#include <qdom.h>
#include <qmessagebox.h>

	/**
 	 * Constructor
   */		
	ApplicationSettings::ApplicationSettings()
	{
		string strMethodName = "ApplicationSettings::ApplicationSettings";
		Debugger::entered(strMethodName);
		Debugger::exited(strMethodName);		
	} // end constructor
	
	/**
 	 * Destructor
   */		
	ApplicationSettings::~ApplicationSettings()
	{
	} // end destructor

	/**
	 * Gets all the application settings from the file.
	 */
	void ApplicationSettings::readSettingsFromFile()
				throw (OpenFileException, XmlParseException)
	{
		string strMethodName = "ApplicationSettings::readSettingsFromFile";
		Debugger::entered(strMethodName);
				
		// lets read from config file and get the application settings
		QString qstrConfigFileName = "config.xml";
		QDomDocument qobjXmlDoc("config");
		
		XmlUtils::parseXmlFile(qstrConfigFileName, qobjXmlDoc);
	
		// lets go through the xml document
		QDomElement qobjRootDomElem = qobjXmlDoc.documentElement();	// get the root element
		
		// lets get to the first child element
		QDomNode qobjDomNode = qobjRootDomElem.firstChild();
		while (qobjDomNode.isNull() == false)
		{
			// lets try to convert the node into a element
			QDomElement qobjDomElem = qobjDomNode.toElement();
			// lets check and see if this element is the database config
 			if (qobjDomElem.tagName() == "databaseconfigfilename")
 			{
 				// lets get the value out and set it
 				m_qstrDatabaseSettingsFileName = qobjDomElem.text();
 				Debugger::logTrace(strMethodName, string("The file name = ") + m_qstrDatabaseSettingsFileName.latin1());
 			} // end if tag name is database settings file
			
			qobjDomNode = qobjDomNode.nextSibling();
		} // end while node is valid
		
		Debugger::exited(strMethodName);
		
	} // end readSettingsFromFile
	
	/**
	 * Returns the filename of where the database settings are.
	 */
	const QString ApplicationSettings::getDatabaseSettingsFileName() const
	{
		return m_qstrDatabaseSettingsFileName;
	} // end getDatabaseSettingsFileName

