/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef OPENFILEEXCEPTION_H
#define OPENFILEEXCEPTION_H

#include "vpsystemexception.h"
#include <string>

/**
 * This exception is thrown when a file cannot be open.
 */
class OpenFileException: public VPSystemException
{
protected:
	string m_strFileName;

public:

	/**
 	 * Constructor
 	 *
 	 * @param	rstrFileName	used to indicate the file name that caused the exception 	
 	 * @param	rstrDescription	used to indicate what the exception was
 	 * @param	rstrClassName		the class that the exception was initially thrown from
 	 * @param	rstrMethodName		the method that the exception was initially thrown from
   */		
	OpenFileException(const string & rstrFileName, const string &rstrDescription,
			const string &rstrClassName, const string &rstrMethodName);
			
	/**
 	 * Copy Constructor
 	 *
 	 * @param	roException			another exception to copy
   */		
	OpenFileException(const OpenFileException &roException);

	/**
 	 * Assignment operator
 	 *
 	 * @param	roException			another exception to assign from
   */		
	OpenFileException & operator=(const OpenFileException &roException);
				
	/**
	 * This function is used to retrieve the file name.
	 * @return	the file name
	 */
	const string & getFileName() const;			
};


#endif

