/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef SEQUENCEGROUPITEMPOPUP_H
#define SEQUENCEGROUPITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "sequencegrouplistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a sequence group item in the list viewer.
 */
class SequenceGroupItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	SequenceGroupListViewItem * m_poSequenceGroupItem;	
	
public:
	/**
	 * Constructor
	 */
	SequenceGroupItemPopup(QWidget *pqoParent, SequenceGroupListViewItem *poSequenceGroupItem);

	/**
	 * Used to access the sequence group list view item.
	 */
	SequenceGroupListViewItem * getSequenceGroupListViewItem() const;
	
protected slots:	
	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the sequence list.
   */	
	void refreshListOfSequences();
		
};


#endif

