/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "serveritempopup.h"
#include "serverpropertiesform.h"
#include "databaselistviewitem.h"

	/**
	 * Constructor
	 */
	ServerItemPopup::ServerItemPopup(QWidget *pqoParent, ServerListViewItem *poServerListViewItem)
		: QPopupMenu(pqoParent)
	{
		m_poServerListViewItem = poServerListViewItem;	// keep a reference to the Server item
		
		// setup all the items and their slots
		insertItem("Add Database", this, SLOT(createDatabaseItem()));
		insertItem("Edit Properties", this, SLOT(editProperties()));		
		insertSeparator();
		insertItem("Delete", this, SLOT(deleteServerItem()));		
	} // end constructor

	/**
	 * Used to get a reference to the database item that this popup was generated from.
	 */
	ServerListViewItem * ServerItemPopup::getServerListViewItem() const
	{
		return m_poServerListViewItem;
	} // end getServerListViewItem

	/**
 	 * This slot is called by the popup menu itself when new database is called
   */	
	void ServerItemPopup::createDatabaseItem()
	{
		DatabaseListViewItem *poDatabaseItem = new DatabaseListViewItem(m_poServerListViewItem);
		QString qstrDatabase1("New Database");
		poDatabaseItem->setText(0, qstrDatabase1);		
		
		if (m_poServerListViewItem->hasExpanded() == true)
		{
			// lets init children for new database
			poDatabaseItem->initChildren();
		} // end if already expanded as well

		// lets open up the list
		m_poServerListViewItem->setOpen(true);
				
		m_poServerListViewItem->listView()->setSelected(poDatabaseItem, true);
	
	} // end createDatabaseItem
	
	/**
 	 * This slot is called by the popup menu itself when edit properties is selected.
   */	
	void ServerItemPopup::editProperties()
	{
		ServerPropertiesForm * poServerPropertiesForm = new ServerPropertiesForm(this);
		poServerPropertiesForm->show();
	} // end editProperties
	
	/**
	 * This slot is called by the popup menu itself when delete server is selected.
	 */
	void ServerItemPopup::deleteServerItem()
	{
		delete m_poServerListViewItem;
	} // end deleteServerItem
	
