/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "tablegrouplistviewitem.h"
#include "tablelistviewitem.h"
#include "tablegroupitempopup.h"
#include "../common/infodialogs.h"
#include "../../dataaccess/tables/dbtablemanager.h"
#include "../../dataaccess/tables/dbtableset.h"
#include "../../dataaccess/tables/dbtable.h"

#include "../../utils/debugger.h"

#include <iostream.h>

	TableGroupListViewItem::TableGroupListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBMasterManagerRef()
	{
		QString qstrTables("Tables");
		setText(0, qstrTables);
		m_qstrDescription = "<h1>Tables</h1><hr><p>Lists all the tables and its properties in this database.</p>";
	} // end constructor

	TableGroupListViewItem::TableGroupListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBMasterManagerRef()
	{
		QString qstrTables("Tables");
		setText(0, qstrTables);
		m_qstrDescription = "<h1>Tables</h1><hr><p>Lists all the tables and its properties in this database.</p>";		
	} // end constructor
				
	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void TableGroupListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new TableGroupItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);

	} // end showRightPressedMenu

	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	void TableGroupListViewItem::initChildren()
	{	
		string strMethodName = "TableGroupListViewItem::initChildren";	
		
		Debugger::entered(strMethodName);

		// temporary table set
		DBTableSet oDBTableSet;
		
		try
		{		
			getDBMasterManager()->getDBTableManager()->retrieveListOfTables(oDBTableSet);
		} // end try
		catch (SQLException e)
		{
			Debugger::logException(strMethodName, e);
			// report error to user
			InfoDialogs::infoSQLException(listView(), e);			
			return;
		} // end catch
		while (oDBTableSet.next())
		{
			TableListViewItem *poTableItem = new TableListViewItem(this);
			// retrieve table details
			oDBTableSet.getDBTable(*poTableItem);
			poTableItem->setText(0, QString(poTableItem->getTableName().c_str()));					
			// set database connection
			poTableItem->setDBMasterManager(getDBMasterManager());
			poTableItem->updateDescription();
		} // end while more
		
		Debugger::exited(strMethodName);
	} // end initChildren
	