/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "visualpsql.h"

#include <qpopupmenu.h>
#include <qapplication.h>
#include <qmenubar.h>
#include <qsplitter.h>
#include <qstring.h>
#include <qvaluelist.h>
#include <qmessagebox.h>
#include <iostream.h>
#include "../utils/debugger.h"
#include "../utils/converter.h"

	VisualPsql::VisualPsql()
    : QMainWindow(0, "pgExplorer", WDestructiveClose)
	{		
		// lets get the application settings
		try
		{
			m_objApplicationSettings.readSettingsFromFile();
		} // end try to read settings from file
		catch (OpenFileException excOpenFile)
		{
			QMessageBox::information(this, "Opening File Error", "Could not open the application settings file, config.xml");  													
		} // end catch open file exception
		catch (XmlParseException excXmlParse)
		{
			QMessageBox::information(this, "Xml Parse Error", "Could not parse the application settings file, config.xml");  															
		} // end catch xml parse exception			
	
		// setup menu
    QPopupMenu *pqoConnectMenu = new QPopupMenu(this);
    menuBar()->insertItem("&Connect", pqoConnectMenu);

    pqoConnectMenu->insertItem("&New Group", this, SLOT(mnuConnectNewGroup()), CTRL+Key_N);
    pqoConnectMenu->insertSeparator();
    pqoConnectMenu->insertItem("E&xit", this, SLOT(mnuConnectExit()), CTRL+Key_Q );

    // setup splitter
    QSplitter *pqoSplitter = new QSplitter(QSplitter::Horizontal, this, "Horizontal splitter" );

    // setup html viewer window
		m_poDescViewer = new DescriptionViewer(pqoSplitter);
		
		// default info
		QString qstrInfo("<h1>pgExplorer v0.1.1</h1><hr><p>This program is licensed under the The Q Public License version 1.0.</p><p>Copyright (c) 2000, 2001 Keith Wong</p>");
		m_poDescViewer->setText(qstrInfo);
		
    // setup tree view
		m_poListView = new MainListView(pqoSplitter);
		QString qstrColumnHdr("Object");
		m_poListView->addColumn(qstrColumnHdr);
		m_poListView->setRootIsDecorated(true);		

		// setup signal/slot between two sides
		connect(m_poListView, SIGNAL(itemDescriptionChanged(const QString &)), m_poDescViewer, SLOT(setDescription(const QString &)));								
		
		// lets set the size of the splitter
		QValueList<int> qoSizeList;
		qoSizeList.append(300);
		qoSizeList.append(550);
		pqoSplitter->setSizes(qoSizeList);		
    pqoSplitter->setFocus();				
    setCentralWidget(pqoSplitter);
		
    resize(750, 550);
	} // end constructor


	VisualPsql::~VisualPsql()
	{
	} // end destructor

	/**
	 * This global function is used to return the application settings for the program.
	 */
	ApplicationSettings & VisualPsql::getApplicationSettings()
	{
		return m_objApplicationSettings;
	} // end getApplicationSettings

	/**
	 * Lets handle the close event.
	 */
	void VisualPsql::closeEvent(QCloseEvent * qobjCloseEvent)
	{
		// save the database settings
		m_poListView->saveDatabaseSettingsToFile();
		qobjCloseEvent->accept();	// lets close down now !
	} // end closeEvent
				
	void VisualPsql::mnuConnectNewGroup()
	{
		m_poListView->addGroupItem();
	} // end mnuConnectNewGroup

	// for exit cleanup
	void VisualPsql::mnuConnectExit()
	{
		// do some cleanup, maybe database connections? warning?
		close();
	} // end mnuConnectExit
