/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "xmlutils.h"
#include <qfile.h>
#include <qtextstream.h>
#include "debugger.h"
#include "converter.h"
	
	/**
 	 * Used to parse an xml file and converts this into a QDomDocument object.
 	 * @param		rqstrFileName 	the file name that is to be open and parsed
 	 * @param		rqoXmlDoc				the output Dom object
 	 * @exception	XmlParseException	is thrown if the document cannot be parsed
 	 * @exception OpenFileException is thrown if the file cannot be opened
   */			    	
	void XmlUtils::parseXmlFile(const QString & rqstrFileName, QDomDocument & rqoXmlDoc)
			throw (XmlParseException, OpenFileException)
	{

		QFile qoFile(rqstrFileName);
		// lets open the file (as read-only)
		if (qoFile.open(IO_ReadOnly) == false)
		{
			// throw open file exception
			throw OpenFileException(rqstrFileName.latin1(), "The file could not be open as read-only.",
							"XmlUtils", "parseXmlFile");							
		} // end if cannot open file
		if (rqoXmlDoc.setContent(&qoFile) == false)
		{
			// done with file, lets close
			qoFile.close();
			// throw exception, can't parse xml
			throw XmlParseException(rqstrFileName.latin1(), "",
							"The XML file could not be parsed.",
							"XmlUtils", "parseXmlFile");										
		} // end if can't parse the xml
		
		// finished parsing, close file
		qoFile.close();

	} // end parseXmlFile

	/**
 	 * Used to save an xml document into a file.
 	 * @param		rqstrFileName 	the file name that is to be open and saved into
 	 * @param		rqoXmlDoc				the Dom object that is to written out to file
 	 * @exception FileNotFoundException is thrown if the file cannot be created/opened
   */			    	
	void XmlUtils::saveXmlDocument(const QString & rqstrFileName, QDomDocument & rqobjXmlDoc)
			throw (OpenFileException)
	{
		string strMethodName = "XmlUtils::saveXmlDocument";
		Debugger::entered(strMethodName);
		
		QFile qobjFile(rqstrFileName);
		// lets open the file (as write-only)
		if (qobjFile.open(IO_WriteOnly) == false)
		{
			// throw open file exception
			throw OpenFileException(rqstrFileName.latin1(), "The file could not be open as write-only.",
							"XmlUtils", "writeXmlFile");							
		} // end if cannot open file
						
		QTextStream qobjTextStream(&qobjFile);
		
		// lets write out the text
		qobjTextStream << rqobjXmlDoc.toString();
		
		// lets close the file... this will write the buffer out too !
		qobjFile.close();
				
		Debugger::exited(strMethodName);		
	} // end writeXmlDocument
