<?
/* product_details.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the 
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");

if (!empty($product_id)) {
	if (empty($id)) {	// category not specified
		$qid = db_query("SELECT category_id FROM products_categories WHERE product_id = '$product_id'");
		if (db_num_rows($qid)) {
			list($id) = db_fetch_row($qid, 0);
		} else {
			header("Location: $CFG->firstpage");
			die;
		}
	} else {
		$qid = db_query("SELECT category_id FROM products_categories WHERE product_id = '$product_id' AND category_id = '$id'");
		if (!db_num_rows($qid)) {
			header("Location: $CFG->firstpage");
			die;
		}
	}
} else {
	header("Location: $CFG->firstpage");
	die;
}

$qid = db_query("
		SELECT
			 p.id AS product_id
			,p.name AS name
			,p.price
			,p.discount
			,p.discqty
			,p.weight
			,p.extended_description
			,p.imagetype
			,p.imagewidth
			,p.imageheight
			,b.name AS bname
			,i.iva
		FROM products p, brands b, iva i
		WHERE p.brand_id = b.id AND p.iva_id = i.id AND p.id = '$product_id'
		");

if (db_num_rows($qid) > 0) {
	$prod = db_fetch_object($qid, 0);
} else {
	$prod = false;
}

$DOC_TITLE = $prod ? "Product_Details" : "Product_Not_Found";

include("$CFG->dirroot"."/header.php");

$t = new Template();
$t->set_file(array("page" => "templates/product_details.ihtml"));
require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
require($CFG->localedir . $SESSION["lang"] . "/global-shopping.inc.php");
$t->set_block("page", "product", "product_blck");
$t->set_var(array("product_blck" => ""));
$t->set_block("page", "noproduct", "noproduct_blck");
$t->set_var(array("noproduct_blck" => ""));
if ($prod) {
	build_category_path($id, $category_path);
	$t->set_var("category_path", $category_path);

	$t->set_block("product", "brand_used", "brand_used_blck");
	$t->set_var("brand_used_blck", "");
	$t->set_block("product", "iva_used", "iva_used_blck");
	$t->set_var("iva_used_blck", "");
	$t->set_block("product", "discount_block", "discount_block_blck");
	$t->set_var("discount_block_blck", "");
		$t->set_block("discount_block", "discqty_block", "discqty_block_blck");
		$t->set_var("discqty_block_blck", "");
	$t->set_block("product", "weight_used", "weight_used_blck");
	$t->set_var("weight_used_blck", "");
	$t->set_block("product", "adminprodimage", "adminprodimage_blck");
	$t->set_var("adminprodimage_blck", "");
	$t->set_block("product", "notadminprodimage", "notadminprodimage_blck");
	$t->set_var("notadminprodimage_blck", "");
	$t->set_var(array(
		"category_id"		=> $id,
		"product_id"		=> $prod->product_id,
		"name"			=> ov($prod->name),
		"price"			=> $prod->price,
		"fprice"		=> formatted_price($prod->price),
		"extended_description"	=> ovwbr($prod->extended_description),
		"imagetype"		=> $prod->imagetype
	));
	if ($SESSION["brand_used"] && $prod->bname != "") {
		$t->set_var("bname", ov($prod->bname));
		$t->parse("brand_used_blck", "brand_used", true);
	}
	if ($SESSION["iva_used"]) {
		$t->set_var("iva", ov($prod->iva));
		$t->parse("iva_used_blck", "iva_used", true);
	}
	if ($prod->discount > 0) {
		$t->set_var("discount", $prod->discount);
		if ($prod->discqty > 1) {
			$t->set_var("discqty", $prod->discqty);
			$t->parse("discqty_block_blck", "discqty_block", true);
		}
		$t->parse("discount_block_blck", "discount_block", true);
	}
	if ($SESSION["weight_used"]) {
		$t->set_var(array(
			"weight"	=> $prod->weight,
			"fweight"	=> formatted_weight($prod->weight)
		));
		$t->parse("weight_used_blck", "weight_used", true);
	}
	if (file_exists($CFG->productsdir.string_cleanup($prod->product_id).".".$prod->imagetype)) {
		$t->set_var(array(
			"imagefilename" => string_cleanup($prod->product_id),
			"imagewidth"    => $prod->imagewidth,
			"imageheight"   => $prod->imageheight
		));
		if (has_priv("admin")) {
			$t->set_var("wwwroot", $CFG->wwwroot);
			$t->parse("adminprodimage_blck", "adminprodimage", true);
		} else {
			$t->set_var("productswww", $CFG->productswww);
			$t->parse("notadminprodimage_blck", "notadminprodimage", true);
		}
	}
	$t->parse("product_blck", "product", true);
} else
	$t->parse("noproduct_blck", "noproduct", true);

$t->pparse("out", "page");
//include("templates/product_details.ihtml");

include("$CFG->dirroot"."/footer.php");

?>
