
--
-- sbox and spoint 
--

SELECT spoint '(0d,90d)' @ sbox '((0d,80d),(360d,90d))' ;

SELECT sbox '((309d,309d),(313d,313d))' ~ spoint '(310d,310d)' ;
SELECT spoint '(310d,310d)' @ sbox '((309d,309d),(313d,313d))' ;
SELECT sbox '((309d,309d),(313d,313d))' ~ spoint '(10d,10d)' ;
SELECT spoint '(10d,10d)' @ sbox '((309d,309d),(313d,313d))' ;

SELECT sbox '((309d,309d),(313d,313d))' !~ spoint '(310d,310d)' ;
SELECT spoint '(310d,310d)' !@ sbox '((309d,309d),(313d,313d))' ;
SELECT sbox '((309d,309d),(313d,313d))' !~ spoint '(10d,10d)' ;
SELECT spoint '(10d,10d)' !@ sbox '((309d,309d),(313d,313d))' ;

--
-- sbox (as point)  and spoint
--

SELECT sbox '((310d,310d),(310d,310d))' ~ spoint '(310d,310d)' ;
SELECT spoint '(310d,310d)' @ sbox '((310d,310d),(310d,310d))' ;
SELECT sbox '((310d,310d),(310d,310d))' ~ spoint '(10d,10d)' ;
SELECT spoint '(11d,11d)' @ sbox '((310d,310d),(310d,310d))' ;

--
-- sbox and circle
--

-- Check negators / commutators

SELECT scircle '<(0d, 70d),1d>' && sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' && scircle '<(0d, 70d),1d>';
SELECT scircle '<(0d, 70d),1d>' !&& sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' !&& scircle '<(0d, 70d),1d>';

SELECT scircle '<(0d, 50d),1d>' && sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' && scircle '<(0d, 50d),1d>';
SELECT scircle '<(0d, 50d),1d>' !&& sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' !&& scircle '<(0d, 50d),1d>';

SELECT scircle '<(0d, 70d),1d>' @ sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' @ scircle '<(0d, 70d),1d>';
SELECT scircle '<(0d, 70d),1d>' !@ sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' !@ scircle '<(0d, 70d),1d>';

SELECT scircle '<(0d, 50d),1d>' @ sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' @ scircle '<(0d, 50d),1d>';
SELECT scircle '<(0d, 50d),1d>' !@ sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' !@ scircle '<(0d, 50d),1d>';

SELECT scircle '<(0d, 70d),1d>' ~ sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' ~ scircle '<(0d, 70d),1d>';
SELECT scircle '<(0d, 70d),1d>' !~ sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' !~ scircle '<(0d, 70d),1d>';

SELECT scircle '<(0d, 50d),1d>' ~ sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' ~ scircle '<(0d, 50d),1d>';
SELECT scircle '<(0d, 50d),1d>' !~ sbox '((-10d, 60d),(10d, 80d))';
SELECT sbox '((-10d, 60d),(10d, 80d))' !~ scircle '<(0d, 50d),1d>';


-- Other Checks

SELECT scircle '<(0d, 90d),1d>'  @ sbox '((0d, 80d),(360d, 90d))'; 
SELECT scircle '<(0d,-90d),1d>'  @ sbox '((0d,-80d),(360d,-90d))'; 
SELECT scircle '<(0d, 90d),1d>' && sbox '((0d, 80d),(360d, 90d))'; 
SELECT scircle '<(0d,-90d),1d>' && sbox '((0d,-80d),(360d,-90d))'; 

SELECT scircle '<(0d, 90d),1d>'  @ sbox '((0d, 80d),(360d, 89d))'; 
SELECT scircle '<(0d,-90d),1d>'  @ sbox '((0d,-80d),(360d,-89d))'; 
SELECT scircle '<(0d, 90d),1d>' && sbox '((0d, 80d),(360d, 89d))'; 
SELECT scircle '<(0d,-90d),1d>' && sbox '((0d,-80d),(360d,-89d))'; 

SELECT scircle '<(0d, 90d),1d>'  @ sbox '((0d, 80d),(360d, 88d))'; 
SELECT scircle '<(0d,-90d),1d>'  @ sbox '((0d,-80d),(360d,-88d))'; 
SELECT scircle '<(0d, 90d),1d>' && sbox '((0d, 80d),(360d, 88d))'; 
SELECT scircle '<(0d,-90d),1d>' && sbox '((0d,-80d),(360d,-88d))'; 

SELECT scircle '<(0d, 90d),1d>'  @ sbox '((0d, 80d),(270d, 90d))'; 
SELECT scircle '<(0d,-90d),1d>'  @ sbox '((0d,-80d),(270d,-90d))'; 
SELECT scircle '<(0d, 90d),1d>' && sbox '((0d, 80d),(270d, 90d))'; 
SELECT scircle '<(0d,-90d),1d>' && sbox '((0d,-80d),(270d,-90d))'; 

SELECT scircle '<(0d, 90d),1d>'  @ sbox '((0d, 80d),(270d, 89d))'; 
SELECT scircle '<(0d,-90d),1d>'  @ sbox '((0d,-80d),(270d,-89d))'; 
SELECT scircle '<(0d, 90d),1d>' && sbox '((0d, 80d),(270d, 89d))'; 
SELECT scircle '<(0d,-90d),1d>' && sbox '((0d,-80d),(270d,-89d))'; 

SELECT scircle '<(0d, 90d),1d>'  @ sbox '((0d, 80d),(270d, 88d))'; 
SELECT scircle '<(0d,-90d),1d>'  @ sbox '((0d,-80d),(270d,-88d))'; 
SELECT scircle '<(0d, 90d),1d>' && sbox '((0d, 80d),(270d, 88d))'; 
SELECT scircle '<(0d,-90d),1d>' && sbox '((0d,-80d),(270d,-88d))'; 

SELECT scircle '<(0d, 90d),1d>'  @ sbox '((0d, 80d),(90d, 90d))'; 
SELECT scircle '<(0d,-90d),1d>'  @ sbox '((0d,-80d),(90d,-90d))'; 
SELECT scircle '<(0d, 90d),1d>' && sbox '((0d, 80d),(90d, 90d))'; 
SELECT scircle '<(0d,-90d),1d>' && sbox '((0d,-80d),(90d,-90d))'; 

SELECT scircle '<(0d, 90d),1d>'  @ sbox '((0d, 80d),(90d, 89d))'; 
SELECT scircle '<(0d,-90d),1d>'  @ sbox '((0d,-80d),(90d,-89d))'; 
SELECT scircle '<(0d, 90d),1d>' && sbox '((0d, 80d),(90d, 89d))'; 
SELECT scircle '<(0d,-90d),1d>' && sbox '((0d,-80d),(90d,-89d))'; 

SELECT scircle '<(0d, 90d),1d>'  @ sbox '((0d, 80d),(90d, 88d))'; 
SELECT scircle '<(0d,-90d),1d>'  @ sbox '((0d,-80d),(90d,-88d))'; 
SELECT scircle '<(0d, 90d),1d>' && sbox '((0d, 80d),(90d, 88d))'; 
SELECT scircle '<(0d,-90d),1d>' && sbox '((0d,-80d),(90d,-88d))'; 

SELECT scircle '<(0d, 89d),1d>'  @ sbox '((0d, 80d),(90d, 90d))'; 
SELECT scircle '<(0d,-89d),1d>'  @ sbox '((0d,-80d),(90d,-90d))'; 
SELECT scircle '<(0d, 89d),1d>' && sbox '((0d, 80d),(90d, 90d))'; 
SELECT scircle '<(0d,-89d),1d>' && sbox '((0d,-80d),(90d,-90d))'; 

SELECT scircle '<(0d, 89d),1d>'  @ sbox '((0d, 80d),(90d, 89d))'; 
SELECT scircle '<(0d,-89d),1d>'  @ sbox '((0d,-80d),(90d,-89d))'; 
SELECT scircle '<(0d, 89d),1d>' && sbox '((0d, 80d),(90d, 89d))'; 
SELECT scircle '<(0d,-89d),1d>' && sbox '((0d,-80d),(90d,-89d))'; 

SELECT scircle '<(0d, 89d),1d>'  @ sbox '((0d, 80d),(90d, 88d))'; 
SELECT scircle '<(0d,-89d),1d>'  @ sbox '((0d,-80d),(90d,-88d))'; 
SELECT scircle '<(0d, 89d),1d>' && sbox '((0d, 80d),(90d, 88d))'; 
SELECT scircle '<(0d,-89d),1d>' && sbox '((0d,-80d),(90d,-88d))'; 

SELECT scircle '<(0d, 90d),10d>'  @ sbox '((0d, 80d),(360d, 90d))';
SELECT scircle '<(0d, 90d),10d>'  ~ sbox '((0d, 80d),(360d, 90d))'; 
SELECT scircle '<(0d, 90d),10d>'  && sbox '((0d, 80d),(360d, 90d))';

--
-- sbox and line
--

SELECT sline( spoint '(0d,0d)', spoint '(0d,10d)' ) @ sbox '((0d,0d),(10d,10d))';
SELECT sline( spoint '(0d,0d)', spoint '(0d,0d)' )  @ sbox '((0d,0d),(10d,10d))';
SELECT sline( spoint '(0d,10d)', spoint '(10d,10d)' ) @ sbox '((0d,0d),(10d,10d))';

SELECT sline( spoint '(0d,0d)', spoint '(0d,10d)' ) && sbox '((0d,0d),(10d,10d))';
SELECT sline( spoint '(0d,0d)', spoint '(0d,0d)' )  && sbox '((0d,0d),(10d,10d))';
SELECT sline( spoint '(0d,10d)', spoint '(10d,10d)' ) && sbox '((0d,0d),(10d,10d))';

