/*
 *  PgSQLNotification.h
 *  PostgresSQL
 *
 *  Created by Pascal on Sun Dec 15 2002.
 *  Copyright (c) 2002 P3 Consulting. All rights reserved.
 *
 */

/*!
@header PgSQLNotification.h
@discussion
	The protocol a class needs to implement to receive PostgreSQLNotification notifications.
	Object passed as delegate for startNotificationFor must implements this protocol.
	startNotificationFor will fail if delegate doesn't implements the protocol 
	(condition is checked by NSAssert).
*/

@protocol PgSQLNotification

/*! 
   @method pgSQLNotify
   @abstract The method called when a PostgreSQLNotification occurs.
*/
-(void)pgSQLNotify:(NSNotification *)notification;

@end
