-- $Id: all.sql,v 1.4 2001/05/05 19:50:16 ciaccia Exp $

BEGIN;

-- MySQL Compatibility functions

CREATE FUNCTION unix_timestamp(timestamp) RETURNS int8 AS
'SELECT (CASE WHEN $1 = NULL THEN 0 ELSE date_part(\'epoch\', $1) END)::int8' LANGUAGE 'sql';

CREATE FUNCTION to_days(timestamp) RETURNS int8 AS
'SELECT floor(CASE WHEN $1 = NULL THEN 0 ELSE unix_timestamp($1)/86400 END)::int8' LANGUAGE 'sql';

CREATE FUNCTION dayofmonth(timestamp) RETURNS int2 AS
'SELECT date_part(\'day\', $1)::int2' LANGUAGE 'sql';

CREATE FUNCTION month(timestamp) RETURNS int2 AS
'SELECT date_part(\'month\', $1)::int2' LANGUAGE 'sql';

CREATE FUNCTION year(timestamp) RETURNS int4 AS
'SELECT date_part(\'year\', $1)::int4' LANGUAGE 'sql';

CREATE FUNCTION week(timestamp) RETURNS int2 AS
'SELECT date_part(\'week\', $1)::int2' LANGUAGE 'sql';

CREATE FUNCTION date_format(timestamp, text) RETURNS text AS
'SELECT CASE WHEN $1 = NULL THEN \'\' ELSE to_char($1, $2) END' LANGUAGE 'sql';

CREATE FUNCTION if(bool, varchar, varchar) RETURNS varchar AS
'SELECT CASE WHEN $1 THEN $2 ELSE $3 END' LANGUAGE 'sql';

-- Table structure for table 'clients'

CREATE SEQUENCE clients_clientID_seq;

CREATE TABLE clients (
   clientID int8 NOT NULL DEFAULT nextval('clients_clientID_seq')::int8,
   clientname varchar(255) NOT NULL,
   contact varchar(255),
   email varchar(64) NOT NULL,
   views int2,
   clicks int2,
   clientusername varchar(64) NOT NULL,
   clientpassword varchar(64) NOT NULL,
   expire date,
   activate date,
   permissions int2,
   language varchar(64),
   active boolean NOT NULL,
   weight int2 default 1 NOT NULL,   
   PRIMARY KEY (clientID)
);


-- Table structure for table 'banners'

CREATE SEQUENCE banners_bannerID_seq;

CREATE TABLE banners (
   bannerID int8 NOT NULL DEFAULT nextval('banners_bannerID_seq')::int8,
   clientID int8 DEFAULT 0 NOT NULL,
   banner text NOT NULL,
   width int2 DEFAULT 0 NOT NULL,
   height int2 DEFAULT 0 NOT NULL,
   format varchar (4) DEFAULT 'gif' NOT NULL, -- enum('gif','jpeg','png','html','url','web')
   url varchar(255) NOT NULL,
   alt varchar(255) NOT NULL,
   keyword varchar(255) NOT NULL,
   bannertext varchar(255) NOT NULL,
   active boolean NOT NULL,
   weight int2 DEFAULT 1 NOT NULL,
   seq int2 DEFAULT 0 NOT NULL,
   target varchar(8) DEFAULT '' NOT NULL,
   description varchar(255) DEFAULT '' NOT NULL,
   PRIMARY KEY (bannerID),
   FOREIGN KEY (clientID) REFERENCES clients (clientID) ON UPDATE CASCADE ON DELETE CASCADE
);


-- Table structure for table 'adclicks'

CREATE TABLE adclicks (
   bannerID int8 DEFAULT '0' NOT NULL,
   t_stamp timestamp,
   host varchar(255) NOT NULL,
   FOREIGN KEY (bannerID) REFERENCES banners(bannerID) ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE INDEX adclicks_bannerID ON adclicks(bannerID);


-- Table structure for table 'adviews'

CREATE TABLE adviews (
   bannerID int8 DEFAULT '0' NOT NULL,
   t_stamp timestamp,
   host varchar(255) NOT NULL,
   FOREIGN KEY (bannerID) REFERENCES banners(bannerID) ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE INDEX adviews_bannerID ON adviews(bannerID);


-- Table structure for table 'session'

CREATE TABLE session (
   SessionID varchar(32) NOT NULL,
   SessionData text NOT NULL,
   LastUsed timestamp,
   PRIMARY KEY (SessionID)
);


-- Table structure for table 'acls'

CREATE TABLE acls (
   bannerID int8 DEFAULT 0 NOT NULL,
   acl_type varchar(12) NOT NULL, -- enum('clientip','useragent','weekday','domain','source','time')
   acl_data varchar(255) NOT NULL,
   acl_ad boolean NOT NULL, -- set('allow','deny')
   acl_order int8 DEFAULT 0 NOT NULL,
   PRIMARY KEY (bannerID, acl_order),
   FOREIGN KEY (bannerID) REFERENCES banners(bannerID) ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE INDEX acls_bannerID ON acls (bannerID);


-- Table structure for table 'adstats'

CREATE TABLE adstats (
  views int4 DEFAULT 0 NOT NULL,
  clicks int4 DEFAULT 0 NOT NULL,
  day date DEFAULT NOW() NOT NULL,
  bannerID int8 DEFAULT 0 NOT NULL,
  PRIMARY KEY (day, bannerID),
  FOREIGN KEY (bannerID) REFERENCES banners(bannerID) ON UPDATE CASCADE ON DELETE CASCADE
);

COMMIT;
