/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ELogFormatter
extends Formatter {
    private static final MessageFormat s_tsFormatter = new MessageFormat("{0,date,dd MMM yy} {0,time,HH:mm:ss} {1} {2}");
    private static final String s_lineSeparator = System.getProperty("line.separator");
    private final Date m_timestamp = new Date();
    private final Object[] m_args = new Object[]{this.m_timestamp, null, null};
    private final StringBuffer m_buffer = new StringBuffer();

    public synchronized String format(LogRecord logRecord) {
        StringBuffer stringBuffer = this.m_buffer;
        stringBuffer.setLength(0);
        this.m_timestamp.setTime(logRecord.getMillis());
        String string = logRecord.getSourceClassName();
        this.m_args[1] = string == null ? logRecord.getLoggerName() : string;
        this.m_args[2] = this.formatMessage(logRecord);
        s_tsFormatter.format(this.m_args, stringBuffer, (FieldPosition)null);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            stringBuffer.append(s_lineSeparator);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            logRecord.getThrown().printStackTrace(printWriter);
            printWriter.close();
            stringBuffer.append(stringWriter.toString());
        }
        return stringBuffer.toString();
    }
}

