/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.jdbc.SPISavepoint;

public class Invocation {
    private static Invocation[] s_levels = new Invocation[10];
    private final int m_nestingLevel;
    private SPISavepoint m_savepoint;
    private ArrayList m_preparedStatements;

    private Invocation(int n) {
        this.m_nestingLevel = n;
    }

    public int getNestingLevel() {
        return this.m_nestingLevel;
    }

    final SPISavepoint getSavepoint() {
        return this.m_savepoint;
    }

    final void manageStatement(PreparedStatement preparedStatement) {
        if (this.m_preparedStatements == null) {
            this.m_preparedStatements = new ArrayList();
        }
        this.m_preparedStatements.add(preparedStatement);
    }

    final void forgetStatement(PreparedStatement preparedStatement) {
        if (this.m_preparedStatements == null) {
            return;
        }
        int n = this.m_preparedStatements.size();
        while (--n >= 0) {
            if (this.m_preparedStatements.get(n) != preparedStatement) continue;
            this.m_preparedStatements.remove(n);
            return;
        }
    }

    final void setSavepoint(SPISavepoint sPISavepoint) {
        this.m_savepoint = sPISavepoint;
    }

    public void onExit() throws SQLException {
        try {
            int n;
            if (this.m_savepoint != null) {
                this.m_savepoint.onInvocationExit();
            }
            if (this.m_preparedStatements != null && (n = this.m_preparedStatements.size()) > 0) {
                Logger logger = Logger.getAnonymousLogger();
                logger.warning("Closing " + n + " \"forgotten\" statement" + (n > 1 ? "s" : ""));
                while (--n >= 0) {
                    PreparedStatement preparedStatement = (PreparedStatement)this.m_preparedStatements.get(n);
                    logger.fine("Closed: " + preparedStatement);
                    preparedStatement.close();
                }
            }
            Object var1_2 = null;
            Invocation.s_levels[this.m_nestingLevel] = null;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            Invocation.s_levels[this.m_nestingLevel] = null;
            throw throwable;
        }
    }

    public static Invocation current() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            Invocation invocation;
            try {
                Invocation invocation2;
                int n = Invocation._getNestingLevel();
                int n2 = s_levels.length;
                if (n <= n2) {
                    invocation2 = s_levels[n];
                    if (invocation2 != null) {
                        Invocation invocation3 = invocation2;
                        Object var5_6 = null;
                        return invocation3;
                    }
                } else {
                    int n3 = n2;
                    while ((n3 <<= 2) <= n) {
                    }
                    Invocation[] invocationArray = new Invocation[n3];
                    System.arraycopy(s_levels, 0, invocationArray, 0, n2);
                    s_levels = invocationArray;
                }
                Invocation.s_levels[n] = invocation2 = new Invocation(n);
                invocation2._register();
                invocation = invocation2;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                throw throwable;
            }
            Object var5_8 = null;
            return invocation;
        }
    }

    static void clearErrorCondition() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                Invocation._clearErrorCondition();
            }
            finally {
                Object var1_1 = null;
            }
            return;
        }
    }

    private native void _register();

    private static native int _getNestingLevel();

    private static native void _clearErrorCondition();
}

