/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.management;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;

public class SQLDeploymentDescriptor {
    private final ArrayList m_installCommands;
    private final ArrayList m_removeCommands;
    private final StringBuffer m_buffer;
    private final char[] m_image;
    private final String m_implementorName;
    private int m_position;

    private /* synthetic */ void finit$() {
        this.m_installCommands = new ArrayList();
        this.m_removeCommands = new ArrayList();
        this.m_buffer = new StringBuffer();
        this.m_position = 0;
    }

    public SQLDeploymentDescriptor(String string, String string2) throws ParseException {
        this.finit$();
        this.m_image = string.toCharArray();
        this.m_implementorName = string2;
        this.readDescriptor();
    }

    public void install(Connection connection) throws SQLException {
        this.executeArray(this.m_installCommands, connection);
    }

    public void remove(Connection connection) throws SQLException {
        this.executeArray(this.m_removeCommands, connection);
    }

    public String toString() {
        return new String(this.m_image);
    }

    private void executeArray(ArrayList arrayList, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            statement.execute(string);
        }
        statement.close();
    }

    private ParseException parseError(String string) {
        return new ParseException(string, this.m_position);
    }

    private void readDescriptor() throws ParseException {
        if (!"SQLACTIONS".equals(this.readIdentifier())) {
            throw this.parseError("Excpected keyword 'SQLActions'");
        }
        this.readToken('[');
        this.readToken(']');
        this.readToken('=');
        this.readToken('{');
        do {
            this.readActionGroup();
        } while (this.readToken("},") != '}');
        int n = this.skipWhite();
        if (n >= 0) {
            throw this.parseError("Extraneous characters at end of descriptor");
        }
    }

    private void readActionGroup() throws ParseException {
        ArrayList arrayList;
        this.readToken('\"');
        if (!"BEGIN".equals(this.readIdentifier())) {
            throw this.parseError("Excpected keyword 'BEGIN'");
        }
        String string = this.readIdentifier();
        if ("INSTALL".equals(string)) {
            arrayList = this.m_installCommands;
        } else if ("REMOVE".equals(string)) {
            arrayList = this.m_removeCommands;
        } else {
            throw this.parseError("Excpected keyword 'INSTALL' or 'REMOVE'");
        }
        while (true) {
            String string2;
            int n;
            String string3;
            int n2;
            if ((n2 = (string3 = this.readCommand()).length()) >= 15 && "BEGIN ".equalsIgnoreCase(string3.substring(0, 6)) && Character.isJavaIdentifierStart(string3.charAt(6))) {
                for (n = 7; n < n2 && Character.isJavaIdentifierPart(string3.charAt(n)); ++n) {
                }
                if (string3.charAt(n) != ' ') {
                    throw this.parseError("Expected whitespace after <implementor name>");
                }
                string2 = string3.substring(6, n);
                int n3 = string2.length();
                int n4 = n2 - n3;
                int n5 = n4 - 4;
                if (!string2.equalsIgnoreCase(string3.substring(n4)) || !"END ".equalsIgnoreCase(string3.substring(n5, n4))) {
                    throw this.parseError("Implementor block must end with END <implementor name>");
                }
                string3 = string2.equalsIgnoreCase(this.m_implementorName) ? string3.substring(n + 1, n5) : null;
            }
            if (string3 != null) {
                arrayList.add(string3.trim());
            }
            n = this.m_position;
            try {
                string2 = this.readIdentifier();
                if ("END".equals(string2) && string.equals(string2 = this.readIdentifier())) break;
                this.m_position = n;
            }
            catch (ParseException parseException) {
                this.m_position = n;
            }
        }
        this.readToken('\"');
    }

    private String readCommand() throws ParseException {
        int n = -1;
        int n2 = 0;
        int n3 = this.skipWhite();
        this.m_buffer.setLength(0);
        block6: while (n3 != -1) {
            switch (n3) {
                case 92: {
                    this.m_buffer.append((char)n3);
                    n3 = this.read();
                    if (n3 == -1) continue block6;
                    this.m_buffer.append((char)n3);
                    n3 = this.read();
                    break;
                }
                case 34: {
                    if (n2 == 0) {
                        throw this.parseError("Unexpected double qoute in SQL command");
                    }
                    this.m_buffer.append((char)n3);
                    n3 = this.read();
                    break;
                }
                case 39: {
                    if (n2 == 0) {
                        n = this.m_position;
                        n2 = n3;
                    } else if (n2 == n3) {
                        n = -1;
                        n2 = 0;
                    }
                    this.m_buffer.append((char)n3);
                    n3 = this.read();
                    break;
                }
                case 59: {
                    if (n2 == 0) {
                        return this.m_buffer.toString();
                    }
                    this.m_buffer.append((char)n3);
                    n3 = this.read();
                    break;
                }
                default: {
                    if (n2 == 0 && Character.isWhitespace((char)n3)) {
                        this.m_buffer.append(' ');
                        n3 = this.skipWhite();
                        break;
                    }
                    this.m_buffer.append((char)n3);
                    n3 = this.read();
                }
            }
        }
        if (n2 != 0) {
            throw this.parseError("Untermintated " + (char)n2 + " starting at position " + n);
        }
        throw this.parseError("Unexpected EOF. Expecting ';' to end command");
    }

    private int skipWhite() throws ParseException {
        int n;
        block11: while (true) {
            if ((n = this.read()) >= 0 && Character.isWhitespace((char)n)) {
                continue;
            }
            if (n != 47) break;
            switch (this.peek()) {
                case 47: {
                    this.skip();
                    while (true) {
                        n = this.read();
                        switch (n) {
                            case -1: 
                            case 10: 
                            case 13: {
                                continue block11;
                            }
                        }
                    }
                }
                case 42: {
                    this.skip();
                    block13: while (true) {
                        n = this.read();
                        switch (n) {
                            case -1: {
                                throw this.parseError("Unexpected EOF when expecting end of multi line comment");
                            }
                            case 42: {
                                if (this.peek() != 47) continue block13;
                                this.skip();
                                continue block11;
                            }
                        }
                    }
                }
            }
            break;
        }
        return n;
    }

    private String readIdentifier() throws ParseException {
        int n = this.skipWhite();
        if (n < 0) {
            throw this.parseError("Unexpected EOF when expecting start of identifier");
        }
        char c = (char)n;
        if (!Character.isJavaIdentifierStart(c)) {
            throw this.parseError("Syntax error at '" + c + "', expected identifier");
        }
        this.m_buffer.setLength(0);
        this.m_buffer.append(c);
        while ((n = this.peek()) >= 0 && Character.isJavaIdentifierPart(c = (char)n)) {
            this.m_buffer.append(c);
            this.skip();
        }
        return this.m_buffer.toString().toUpperCase();
    }

    private char readToken(String string) throws ParseException {
        int n = this.skipWhite();
        if (n < 0) {
            throw this.parseError("Unexpected EOF when expecting one of \"" + string + '\"');
        }
        char c = (char)n;
        if (string.indexOf(c) < 0) {
            throw this.parseError("Syntax error at '" + c + "', expected one of '" + string + "'");
        }
        return c;
    }

    private char readToken(char c) throws ParseException {
        int n = this.skipWhite();
        if (n < 0) {
            throw this.parseError("Unexpected EOF when expecting token '" + c + '\'');
        }
        char c2 = (char)n;
        if (c2 != c) {
            throw this.parseError("Syntax error at '" + c2 + "', expected '" + c + "'");
        }
        return c2;
    }

    private int peek() {
        if (this.m_position >= this.m_image.length) {
            return -1;
        }
        return this.m_image[this.m_position];
    }

    private void skip() {
        ++this.m_position;
    }

    private int read() {
        int n;
        if ((n = this.m_position++) >= this.m_image.length) {
            return -1;
        }
        return this.m_image[n];
    }
}

