/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.test;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

public class Tester {
    private static final int CMD_AMBIGUOUS = -2;
    private static final int CMD_UNKNOWN = -1;
    private static final int CMD_USER = 0;
    private static final int CMD_PASSWORD = 1;
    private static final int CMD_DATABASE = 2;
    private static final int CMD_HOSTNAME = 3;
    private static final int CMD_PORT = 4;
    private static final int CMD_DEBUG = 5;
    private final Connection m_connection;
    private static final ArrayList s_commands = new ArrayList();

    private static final int getCommand(String string) {
        int n = s_commands.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!((String)s_commands.get(i)).startsWith(string)) continue;
            if (n2 != -1) {
                return -2;
            }
            n2 = i;
        }
        return n2;
    }

    public static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("usage: java -jar deploy.jar");
        printStream.println("    {-install | -uninstall | -reinstall}");
        printStream.println("    [ -host <hostName>     ]    # default is localhost");
        printStream.println("    [ -port <portNubmer>   ]    # default is blank");
        printStream.println("    [ -database <database> ]    # default is name of current user");
        printStream.println("    [ -user <userName>     ]    # default is name of current user");
        printStream.println("    [ -password <password> ]    # default is no password");
        printStream.println("    [ -debug ]    # wait for debugger to attach to backend");
    }

    public static void main(String[] stringArray) {
        Object object;
        String string;
        String string2 = "org.postgresql.Driver";
        String string3 = "localhost";
        String string4 = null;
        String string5 = string = System.getProperty("user.name", "postgres");
        String string6 = "postgresql";
        String string7 = null;
        boolean bl = false;
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            object = stringArray[i];
            if (((String)object).length() < 2) {
                Tester.printUsage();
                return;
            }
            if (((String)object).charAt(0) != '-') continue;
            int n2 = Tester.getCommand(((String)object).substring(1));
            switch (n2) {
                case 5: {
                    bl = true;
                    continue block10;
                }
                case 0: {
                    if (++i < n && (string = stringArray[i]).length() > 0 && string.charAt(0) != '-') continue block10;
                    Tester.printUsage();
                    return;
                }
                case 1: {
                    if (++i < n && (string7 = stringArray[i]).length() > 0 && string7.charAt(0) != '-') continue block10;
                    Tester.printUsage();
                    return;
                }
                case 2: {
                    if (++i < n && (string5 = stringArray[i]).length() > 0 && string5.charAt(0) != '-') continue block10;
                    Tester.printUsage();
                    return;
                }
                case 3: {
                    if (++i < n && (string3 = stringArray[i]).length() > 0 && string3.charAt(0) != '-') continue block10;
                    Tester.printUsage();
                    return;
                }
                case 4: {
                    if (++i < n && (string4 = stringArray[i]).length() > 0 && string4.charAt(0) != '-') continue block10;
                    Tester.printUsage();
                    return;
                }
                default: {
                    Tester.printUsage();
                    return;
                }
            }
        }
        try {
            Class.forName(string2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("jdbc:");
            stringBuffer.append(string6);
            stringBuffer.append("://");
            stringBuffer.append(string3);
            if (string4 != null) {
                stringBuffer.append(':');
                stringBuffer.append(string4);
            }
            stringBuffer.append('/');
            stringBuffer.append(string5);
            object = DriverManager.getConnection(stringBuffer.toString(), string, string7);
            Tester tester = new Tester((Connection)object);
            if (bl) {
                System.out.println("Attach debugger to backend");
                Thread.sleep(30000L);
                System.out.println("continuing");
            }
            for (int i = 0; i < 10; ++i) {
                tester.testParameters();
                tester.testInsertUsernameTrigger();
                tester.testModdatetimeTrigger();
                tester.testSPIActions();
                tester.testComplexReturn();
                tester.testSetReturn();
                tester.testCallInCall();
                tester.testCurrentDir();
                tester.testUsingProperties();
                tester.testUsingScalarProperties();
                tester.testSavepointSanity();
            }
            tester.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Tester(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("SET search_path TO javatest,public");
        statement.close();
        this.m_connection = connection;
    }

    public void close() throws SQLException {
        this.m_connection.close();
    }

    public void testParameters() throws SQLException {
        this.testTimestamp();
        this.testInt();
    }

    public void testSPIActions() throws SQLException {
        System.out.println("*** testSPIActions()");
        Statement statement = this.m_connection.createStatement();
        statement.execute("DELETE FROM employees1");
        statement.execute("DELETE FROM employees2");
        statement.execute("INSERT INTO employees1 VALUES(1, 'Calvin Forrester', 10000)");
        statement.execute("INSERT INTO employees1 VALUES(2, 'Edwin Archer', 20000)");
        statement.execute("INSERT INTO employees1 VALUES(3, 'Rebecka Shawn', 30000)");
        statement.execute("INSERT INTO employees1 VALUES(4, 'Priscilla Johnson', 25000)");
        statement.execute("SELECT transferPeople(20000)");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM employees2");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            String string = resultSet.getString(2);
            int n2 = resultSet.getInt(3);
            System.out.println("Id = \"" + n + "\", name = \"" + string + "\", salary = \"" + n2 + "\"");
        }
        resultSet.close();
    }

    public void testComplexReturn() throws SQLException {
        System.out.println("*** testComplexReturn()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT complexReturnToString(complexReturnExample(1, 5))");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            System.out.println(string);
        }
        resultSet.close();
    }

    public void testSetReturn() throws SQLException {
        System.out.println("*** testSetReturn()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT base, incbase, ctime FROM setReturnExample(1, 5)");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            int n2 = resultSet.getInt(2);
            Timestamp timestamp = resultSet.getTimestamp(3);
            System.out.println("Base = \"" + n + "\", incbase = \"" + n2 + "\", ctime = \"" + timestamp + "\"");
        }
        resultSet.close();
    }

    public void testUsingProperties() throws SQLException {
        System.out.println("*** testUsingProperties()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT name, value FROM propertyExample()");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            System.out.println("Name = \"" + string + "\", value = \"" + string2 + "\"");
        }
        resultSet.close();
    }

    public void testUsingScalarProperties() throws SQLException {
        System.out.println("*** testUsingScalarProperties()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT scalarPropertyExample()");
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1));
        }
        resultSet.close();
    }

    public void testCallInCall() throws SQLException {
        System.out.println("*** testCallInCall()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT maxFromSetReturnExample(10, 8)");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            System.out.println("Max = \"" + n + "\"");
        }
    }

    public void testModdatetimeTrigger() throws SQLException {
        Timestamp timestamp;
        String string;
        int n;
        System.out.println("*** testModdatetimeTrigger()");
        Statement statement = this.m_connection.createStatement();
        statement.execute("DELETE FROM mdt");
        statement.execute("INSERT INTO mdt VALUES (1, 'first')");
        statement.execute("INSERT INTO mdt VALUES (2, 'second')");
        statement.execute("INSERT INTO mdt VALUES (3, 'third')");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM mdt");
        while (resultSet.next()) {
            n = resultSet.getInt(1);
            string = resultSet.getString(2);
            timestamp = resultSet.getTimestamp(3);
            System.out.println("Id = \"" + n + "\", idesc = \"" + string + "\", moddate = \"" + timestamp + "\"");
        }
        resultSet.close();
        statement.execute("UPDATE mdt SET id = 4 WHERE id = 1");
        statement.execute("UPDATE mdt SET id = 5 WHERE id = 2");
        statement.execute("UPDATE mdt SET id = 6 WHERE id = 3");
        resultSet = statement.executeQuery("SELECT * FROM mdt");
        while (resultSet.next()) {
            n = resultSet.getInt(1);
            string = resultSet.getString(2);
            timestamp = resultSet.getTimestamp(3);
            System.out.println("Id = \"" + n + "\", idesc = \"" + string + "\", moddate = \"" + timestamp + "\"");
        }
        resultSet.close();
        statement.close();
    }

    public void testInsertUsernameTrigger() throws SQLException {
        System.out.println("*** testInsertUsernameTrigger()");
        Statement statement = this.m_connection.createStatement();
        statement.execute("DELETE FROM username_test");
        statement.execute("INSERT INTO username_test VALUES ('nothing', 'thomas')");
        statement.execute("INSERT INTO username_test VALUES ('null', null)");
        statement.execute("INSERT INTO username_test VALUES ('empty string', '')");
        statement.execute("INSERT INTO username_test VALUES ('space', ' ')");
        statement.execute("INSERT INTO username_test VALUES ('tab', '\t')");
        statement.execute("INSERT INTO username_test VALUES ('name', 'name')");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM username_test");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            System.out.println("Name = \"" + string + "\", username = \"" + string2 + "\"");
        }
        resultSet.close();
        statement.close();
    }

    public void testTimestamp() throws SQLException {
        System.out.println("*** testTimestamp()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT java_getTimestamp(), java_getTimestamptz()");
        if (!resultSet.next()) {
            System.out.println("Unable to position ResultSet");
        } else {
            System.out.println("Timestamp = " + resultSet.getTimestamp(1) + ", Timestamptz = " + resultSet.getTimestamp(2));
        }
        resultSet.close();
        statement.execute("SELECT java_print(current_date)");
        statement.execute("SELECT java_print(current_time)");
        statement.execute("SELECT java_print(current_timestamp)");
        statement.close();
    }

    public void testInt() throws SQLException {
        System.out.println("*** testInt()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT java_addOne(java_addOne(54)), nullOnEven(1), nullOnEven(2)");
        if (!resultSet.next()) {
            System.out.println("Unable to position ResultSet");
        } else {
            System.out.println("54 + 2 = " + resultSet.getInt(1));
            int n = resultSet.getInt(2);
            System.out.println("nullOnEven(1) = " + (resultSet.wasNull() ? "null" : Integer.toString(n)));
            n = resultSet.getInt(3);
            System.out.println("nullOnEven(2) = " + (resultSet.wasNull() ? "null" : Integer.toString(n)));
        }
        resultSet.close();
        statement.close();
    }

    public void testCurrentDir() throws SQLException {
        System.out.println("*** testCurrentDir()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT java_getSystemProperty('user.dir')");
        if (!resultSet.next()) {
            System.out.println("Unable to position ResultSet");
        } else {
            System.out.println("Server directory = " + resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testSavepointSanity() throws SQLException {
        System.out.println("*** testSavepointSanity()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT testSavepointSanity()");
        if (!resultSet.next()) {
            System.out.println("Unable to position ResultSet");
        } else {
            System.out.println("Savepoint sanity = " + resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    static {
        s_commands.add(0, "user");
        s_commands.add(1, "password");
        s_commands.add(2, "database");
        s_commands.add(3, "host");
        s_commands.add(4, "port");
        s_commands.add(5, "debug");
    }
}

