/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import org.postgresql.pljava.ResultSetProvider;

public class MetaDataInts
implements ResultSetProvider {
    String[] methodNames;
    Integer[] methodResults;

    public MetaDataInts() throws SQLException {
        Logger logger = Logger.getAnonymousLogger();
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        Method[] methodArray = DatabaseMetaData.class.getMethods();
        class MethodComparator
        implements Comparator {
            MethodComparator() {
            }

            public int compare(Object object, Object object2) {
                return ((Method)object).getName().compareTo(((Method)object2).getName());
            }
        }
        Arrays.sort(methodArray, new MethodComparator());
        Object[] objectArray = new Object[]{};
        Integer n = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?> clazz;
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            if (classArray.length > 0 || !(clazz = methodArray[i].getReturnType()).equals(Integer.TYPE)) continue;
            try {
                n = (Integer)methodArray[i].invoke((Object)databaseMetaData, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.info("Method: " + methodArray[i].getName() + " => " + invocationTargetException.getTargetException().getMessage());
                n = new Integer(-1);
            }
            catch (Exception exception) {
                logger.info("Method: " + methodArray[i].getName() + " => " + exception.getMessage());
                n = new Integer(-1);
            }
            arrayList.add(methodArray[i].getName());
            arrayList2.add(n);
        }
        this.methodNames = arrayList.toArray(new String[arrayList.size()]);
        this.methodResults = arrayList2.toArray(new Integer[arrayList2.size()]);
    }

    public boolean assignRowValues(ResultSet resultSet, int n) throws SQLException {
        if (n < this.methodNames.length) {
            resultSet.updateString(1, this.methodNames[n]);
            resultSet.updateInt(2, (int)this.methodResults[n]);
            return true;
        }
        return false;
    }

    public void close() {
    }

    public static ResultSetProvider getDatabaseMetaDataInts() throws SQLException {
        try {
            return new MetaDataInts();
        }
        catch (SQLException sQLException) {
            throw new SQLException("Error reading DatabaseMetaData", sQLException.getMessage());
        }
    }
}

