/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.deploy;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class Deployer {
    private static final int CMD_AMBIGUOUS = -2;
    private static final int CMD_UNKNOWN = -1;
    private static final int CMD_UNINSTALL = 0;
    private static final int CMD_INSTALL = 1;
    private static final int CMD_REINSTALL = 2;
    private static final int CMD_USER = 3;
    private static final int CMD_PASSWORD = 4;
    private static final int CMD_DATABASE = 5;
    private static final int CMD_HOSTNAME = 6;
    private static final int CMD_WINDOWS = 7;
    private final Connection m_connection;
    private static final ArrayList s_commands = new ArrayList();

    static {
        s_commands.add(0, "uninstall");
        s_commands.add(1, "install");
        s_commands.add(2, "reinstall");
        s_commands.add(3, "user");
        s_commands.add(4, "password");
        s_commands.add(5, "database");
        s_commands.add(6, "host");
        s_commands.add(7, "windows");
    }

    private static final int getCommand(String arg) {
        int top = s_commands.size();
        int candidateCmd = -1;
        int idx = 0;
        while (idx < top) {
            if (((String)s_commands.get(idx)).startsWith(arg)) {
                if (candidateCmd != -1) {
                    return -2;
                }
                candidateCmd = idx;
            }
            ++idx;
        }
        return candidateCmd;
    }

    public static void printUsage() {
        PrintStream out = System.err;
        out.println("usage: java -jar deploy.jar");
        out.println("    {-install | -uninstall | -reinstall}");
        out.println("    [ -host <hostName>     ]    # default is localhost");
        out.println("    [ -database <database> ]    # default is postgres");
        out.println("    [ -user <userName>     ]    # default is postgres");
        out.println("    [ -password <password> ]    # default is no password");
        out.println("    [ -windows ]                # If the server is on a Windows machine");
    }

    public static void main(String[] argv) {
        String driverClass = "org.postgresql.Driver";
        String hostName = "localhost";
        String database = "postgres";
        String userName = "postgres";
        String subsystem = "postgresql";
        String password = null;
        boolean unix = true;
        int cmd = -1;
        int top = argv.length;
        int idx = 0;
        while (idx < top) {
            String arg = argv[idx];
            if (arg.length() < 2) {
                Deployer.printUsage();
                return;
            }
            if (arg.charAt(0) == '-') {
                int optCmd = Deployer.getCommand(arg.substring(1));
                switch (optCmd) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (cmd != -1) {
                            Deployer.printUsage();
                            return;
                        }
                        cmd = optCmd;
                        break;
                    }
                    case 3: {
                        if (++idx < top && (userName = argv[idx]).length() > 0 && userName.charAt(0) != '-') break;
                        Deployer.printUsage();
                        return;
                    }
                    case 4: {
                        if (++idx < top && (password = argv[idx]).length() > 0 && password.charAt(0) != '-') break;
                        Deployer.printUsage();
                        return;
                    }
                    case 5: {
                        if (++idx < top && (database = argv[idx]).length() > 0 && database.charAt(0) != '-') break;
                        Deployer.printUsage();
                        return;
                    }
                    case 6: {
                        if (++idx < top && (hostName = argv[idx]).length() > 0 && hostName.charAt(0) != '-') break;
                        Deployer.printUsage();
                        return;
                    }
                    case 7: {
                        unix = false;
                        break;
                    }
                    default: {
                        Deployer.printUsage();
                        return;
                    }
                }
            }
            ++idx;
        }
        if (cmd == -1) {
            Deployer.printUsage();
            return;
        }
        try {
            Class.forName(driverClass);
            Connection c = DriverManager.getConnection("jdbc:" + subsystem + "://" + hostName + '/' + database, userName, password);
            Deployer deployer = new Deployer(c);
            if (cmd == 0 || cmd == 2) {
                deployer.dropSQLJSchema();
            }
            if (cmd == 1 || cmd == 2) {
                deployer.createSQLJSchema();
                deployer.initJavaHandler(unix);
                deployer.initializeSQLJSchema();
            }
            c.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Deployer(Connection c) {
        this.m_connection = c;
    }

    public void dropSQLJSchema() throws SQLException {
        Statement stmt = this.m_connection.createStatement();
        stmt.execute("DROP SCHEMA sqlj CASCADE");
        try {
            stmt.execute("DROP LANGUAGE java CASCADE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.close();
    }

    public void createSQLJSchema() throws SQLException {
        Statement stmt = this.m_connection.createStatement();
        stmt.execute("CREATE SCHEMA sqlj");
        stmt.close();
    }

    public void initializeSQLJSchema() throws SQLException {
        Statement stmt = this.m_connection.createStatement();
        stmt.execute("CREATE TABLE sqlj.jar_repository(\tjarId\t\tSERIAL PRIMARY KEY,\tjarName\t\tVARCHAR(100) UNIQUE NOT NULL,   jarOrigin   VARCHAR(500) NOT NULL)");
        stmt.execute("CREATE TABLE sqlj.jar_entry(   entryId     SERIAL PRIMARY KEY,\tentryName\tVARCHAR(200) NOT NULL,\tjarId\t\tINT NOT NULL REFERENCES sqlj.jar_repository ON DELETE CASCADE,   entryImage  BYTEA NOT NULL)");
        stmt.execute("CREATE TABLE sqlj.classpath_entry(\tschemaName\tVARCHAR(30) NOT NULL,\tordinal\t\tINT2 NOT NULL,\tjarId\t\tINT NOT NULL REFERENCES sqlj.jar_repository ON DELETE CASCADE,\tPRIMARY KEY(schemaName, ordinal))");
        stmt.execute("CREATE FUNCTION sqlj.install_jar(VARCHAR, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.installJar'\tLANGUAGE java");
        stmt.execute("CREATE FUNCTION sqlj.replace_jar(VARCHAR, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.replaceJar'\tLANGUAGE java");
        stmt.execute("CREATE FUNCTION sqlj.remove_jar(VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.removeJar'\tLANGUAGE java");
        stmt.execute("CREATE FUNCTION sqlj.set_classpath(VARCHAR, VARCHAR) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.setClassPath'\tLANGUAGE java");
        stmt.execute("CREATE FUNCTION sqlj.get_classpath(VARCHAR) RETURNS VARCHAR\tAS 'org.postgresql.pljava.management.Commands.getClassPath'\tLANGUAGE java");
        stmt.close();
    }

    public void initJavaHandler(boolean unix) throws SQLException {
        Statement stmt = this.m_connection.createStatement();
        stmt.execute("CREATE FUNCTION sqlj.java_call_handler() RETURNS language_handler AS '" + (unix ? "lib" : "") + "pljava'" + " LANGUAGE C");
        stmt.execute("CREATE LANGUAGE java HANDLER sqlj.java_call_handler");
        stmt.close();
    }
}

