/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.postgresql.pljava.jdbc.AbstractResultSet;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public abstract class ObjectResultSet
extends AbstractResultSet {
    private boolean m_wasNull = false;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$net$URL;

    public void clearWarnings() throws SQLException {
    }

    public Array getArray(int n) throws SQLException {
        return (Array)this.getValue(n, class$java$sql$Array == null ? (class$java$sql$Array = ObjectResultSet.class$("java.sql.Array")) : class$java$sql$Array);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        Clob clob = this.getClob(n);
        return clob == null ? null : clob.getAsciiStream();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)this.getValue(n, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ObjectResultSet.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new UnsupportedFeatureException("getBigDecimal(int, int)");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        Blob blob = this.getBlob(n);
        return blob == null ? null : blob.getBinaryStream();
    }

    public Blob getBlob(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return byArray == null ? null : new BlobValue(byArray);
    }

    public boolean getBoolean(int n) throws SQLException {
        Boolean bl = (Boolean)this.getValue(n, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ObjectResultSet.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        return bl == null ? false : bl;
    }

    public byte getByte(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? (byte)0 : number.byteValue();
    }

    public byte[] getBytes(int n) throws SQLException {
        return (byte[])this.getValue(n, array$B == null ? (array$B = ObjectResultSet.class$("[B")) : array$B);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        Clob clob = this.getClob(n);
        return clob == null ? null : clob.getCharacterStream();
    }

    public Clob getClob(int n) throws SQLException {
        String string = this.getString(n);
        return string == null ? null : new ClobValue(string);
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.getValue(n, class$java$sql$Date == null ? (class$java$sql$Date = ObjectResultSet.class$("java.sql.Date")) : class$java$sql$Date);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return (Date)this.getValue(n, class$java$sql$Date == null ? (class$java$sql$Date = ObjectResultSet.class$("java.sql.Date")) : class$java$sql$Date, calendar);
    }

    public double getDouble(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0.0 : number.doubleValue();
    }

    public float getFloat(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0.0f : number.floatValue();
    }

    public int getInt(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0 : number.intValue();
    }

    public long getLong(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0L : number.longValue();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedFeatureException("ResultSet meta data is not yet implemented");
    }

    public final Object getObject(int n) throws SQLException {
        Object object = this.getObjectValue(n);
        this.m_wasNull = object == null;
        return object;
    }

    public final Object getObject(int n, Map map) throws SQLException {
        Object object = this.getObjectValue(n, map);
        this.m_wasNull = object == null;
        return object;
    }

    public Ref getRef(int n) throws SQLException {
        return (Ref)this.getValue(n, class$java$sql$Ref == null ? (class$java$sql$Ref = ObjectResultSet.class$("java.sql.Ref")) : class$java$sql$Ref);
    }

    public short getShort(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? (short)0 : number.shortValue();
    }

    public String getString(int n) throws SQLException {
        return (String)this.getValue(n, class$java$lang$String == null ? (class$java$lang$String = ObjectResultSet.class$("java.lang.String")) : class$java$lang$String);
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.getValue(n, class$java$sql$Time == null ? (class$java$sql$Time = ObjectResultSet.class$("java.sql.Time")) : class$java$sql$Time);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return (Time)this.getValue(n, class$java$sql$Time == null ? (class$java$sql$Time = ObjectResultSet.class$("java.sql.Time")) : class$java$sql$Time, calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getValue(n, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ObjectResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return (Timestamp)this.getValue(n, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ObjectResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, calendar);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new UnsupportedFeatureException("ResultSet.getUnicodeStream");
    }

    public URL getURL(int n) throws SQLException {
        return (URL)this.getValue(n, class$java$net$URL == null ? (class$java$net$URL = ObjectResultSet.class$("java.net.URL")) : class$java$net$URL);
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedFeatureException("Refresh row");
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.updateObject(n, (Object)array);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.updateObject(n, (Object)new ClobValue(new InputStreamReader(inputStream, "US-ASCII"), n2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("US-ASCII encoding is not supported by this JVM");
        }
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateBlob(n, (Blob)new BlobValue(inputStream, n2));
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateObject(n, (Object)blob);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Byte(by));
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.updateClob(n, (Clob)new ClobValue(reader, n2));
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateObject(n, (Object)clob);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    public void updateNull(int n) throws SQLException {
        this.updateObject(n, null);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.updateObject(n, (Object)ref);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Short(s));
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    public boolean wasNull() {
        return this.m_wasNull;
    }

    protected final Number getNumber(int n) throws SQLException {
        Object object = this.getObjectValue(n);
        boolean bl = this.m_wasNull = object == null;
        if (this.m_wasNull || object instanceof Number) {
            return (Number)object;
        }
        throw new SQLException("Cannot derive a Number from an object of class " + object.getClass().getName());
    }

    protected final Object getValue(int n, Class clazz) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || clazz.isInstance(object)) {
            return object;
        }
        throw new SQLException("Cannot derive a value of class " + clazz.getName() + " from an object of class " + object.getClass().getName());
    }

    protected Object getValue(int n, Class clazz, Calendar calendar) throws SQLException {
        if (calendar == null || calendar == Calendar.getInstance()) {
            return this.getValue(n, clazz);
        }
        throw new UnsupportedFeatureException("Obtaining date, time, or timestamp using explicit Calendar");
    }

    protected Object getObjectValue(int n, Map map) throws SQLException {
        if (map == null) {
            return this.getObjectValue(n);
        }
        throw new UnsupportedFeatureException("Obtaining values using explicit Map");
    }

    protected abstract Object getObjectValue(int var1) throws SQLException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

