/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.SingleRowResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class TriggerResultSet
extends SingleRowResultSet {
    private ArrayList m_tupleChanges;
    private final Tuple m_tuple;
    private final boolean m_readOnly;

    public TriggerResultSet(TupleDesc tupleDesc, Tuple tuple, boolean bl) throws SQLException {
        super(tupleDesc);
        this.m_tuple = tuple;
        this.m_readOnly = bl;
    }

    public void cancelRowUpdates() throws SQLException {
        this.m_tupleChanges = null;
    }

    public int getConcurrency() throws SQLException {
        return this.m_readOnly ? 1007 : 1008;
    }

    public boolean rowUpdated() throws SQLException {
        return this.m_tupleChanges != null;
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (this.m_readOnly) {
            throw new UnsupportedFeatureException("ResultSet is read-only");
        }
        if (this.m_tupleChanges == null) {
            this.m_tupleChanges = new ArrayList();
        }
        this.m_tupleChanges.add(new Integer(n));
        this.m_tupleChanges.add(object);
    }

    public Object[] getChangeIndexesAndValues() {
        ArrayList arrayList = this.m_tupleChanges;
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        if (arrayList.size() == 0) {
            return null;
        }
        int[] nArray = new int[n /= 2];
        Object[] objectArray = new Object[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = (Integer)arrayList.get(n2++);
            objectArray[n3] = arrayList.get(n2++);
            ++n3;
        }
        return new Object[]{this.m_tuple, nArray, objectArray};
    }

    protected Object getObjectValue(int n) throws SQLException {
        ArrayList arrayList = this.m_tupleChanges;
        if (arrayList != null) {
            int n2 = arrayList.size();
            int n3 = 0;
            while (n3 < n2) {
                if (n == (Integer)arrayList.get(n3)) {
                    return arrayList.get(n3 + 1);
                }
                n3 += 2;
            }
        }
        return this.m_tuple.getObject(this.getTupleDesc(), n);
    }
}

