#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $PostgresPy: if/setup.py,v 1.23 2004/07/28 11:27:44 flaw Exp $
#
# † Instrument:
#     Copyright 2004, rhid development, All Rights Reserved.
#     
#     Usage of the works is permitted provided that this
#     instrument is retained with the works, so that any entity
#     that uses the works is notified of this instrument.
#     
#     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
#     
#     [2004, Fair License; rhid.com/fair]
#     
##
# Description:
#    Regular setup.py, uses pg_config from $PATH to locate
#    the target PostgreSQL installation.
##
import sys, os
from distutils.core import setup
from distutils.core import Extension
from distutils.sysconfig import get_python_inc
from os.path import join

def Pickle():
	try:
		import cPickle as pickle
	except ImportError:
		import pickle
	return pickle
def Pickler():
	return Pickle().Pickler
def Unpickler():
	return Pickle().Unpickler

import distutils.command.config as distconfig
class config(distconfig.config):
	description = "configure build and installation against arguments"
	user_options = [
		('postgresql=', 'P',
		 'PostgreSQL installation to depend on'),
		('postgresql-headers=', None,
		 'PostgreSQL server headers path'),
		('define=', 'D',
		 'C preprocessor macros to define'),
		('undef=', 'U',
		 'C preprocessor macros to undefine'),
	]

	def initialize_options(self):
		self.postgresql = 'pg_config'
		self.postgresql_headers = None
		self.define = []
		self.undef = []

	def finalize_options(self):
		if self.define != []:
			self.define = self.define.split(',')
		if self.undef != []:
			self.undef = self.undef.split(',')

	def run(self):
		try:
			CFG = Unpickler()(file('setup.pyk', 'r')).load()
		except IOError:
			from commands import getoutput
			CFG = {}
			# PostgresPy has major versions and timestamps
			try:
				CFG['VERSION'] = str(file('VERSION').read()).strip()
			except IOError:
				# HEAD has no VERSION file
				CFG['VERSION'] = ''

			CFG['DEFINES'] = ['-D' + x for x in self.define]
			CFG['UNDEFINES'] = ['-U' + x for x in self.undef]
			# XXX: UNIX SPECIFIC
			if os.name == 'posix':
				CFG['PG_CONFIG'] = self.postgresql
				if self.postgresql_headers == None:
					CFG['PG_INCLUDE'] = getoutput(
						CFG['PG_CONFIG'] + ' --includedir-server'
					)
				else:
					CFG['PG_INCLUDE'] = self.postgresql_headers
				pgv = getoutput(CFG['PG_CONFIG'] + ' --version')
				CFG['PG_VERSION'] = pgv.split(' ')[1]
				CFG['PGV_MAJOR'] = CFG['PG_VERSION'][0]
				CFG['PGV_MINOR'] = CFG['PG_VERSION'][2]
				if CFG['PG_VERSION'][3] == '.':
					CFG['PGV_PATCH'] = CFG['PG_VERSION'][4]
					CFG['PGV_META'] = CFG['PG_VERSION'][5:-1]
				else:
					CFG['PGV_PATCH'] = '0'
					CFG['PGV_META'] = CFG['PG_VERSION'][4:-1]
				CFG['PGV_MM'] = CFG['PGV_MAJOR'] + CFG['PGV_MINOR']
			else:
				from distutils.errors import DistutilsPlatformError as E
				raise E('I am too stupid to build on anything other than posix')

			CFG['I'] = [
				join(sys.path[0],'include'),
				'/usr/local/include',
				CFG['PG_INCLUDE']
			]

			# Mutual Headers And C-files
			MHAC = [
				'void',
				'pstream',
				'utils',
				'datum',
				'tupd',
				'tup',
				'type',
				'obj',
				'rel',
				'query',
				'portal',
				'module'
			]

			# Construct source and header list
			#
			source_prefix = 'src'
			CFG["XSOURCES"] = [ join(source_prefix, src+'.c')
				for src in MHAC+['globals']
			]

			CFG["XINCLUDES"] = [ join(source_prefix, inc+'.h')
				for inc in MHAC
			]

			CFG["XINCLUDES"] += [ join('include', inc)
			for inc in
				'PGExcept.h',
				'except.h',
				'pputils.h',
				'pg.h',
				'py.h'
			]

			CFG['INCLUDE_DST'] = join(get_python_inc(), 'pgpy')

			CFG['XN'] = 'pg' + CFG['PGV_MM']
			CFG['XPATH'] = 'postgres.' + '_' + CFG['XN']
			CFG['XPPI'] = join('postgres', CFG['XN']+'.py')

			imodsrc = file(join('src', 'pg.py'), 'r').read()
			imod = file(CFG['XPPI'], 'w')
			imod.write(imodsrc % (CFG['VERSION'], CFG['PGV_MM']))
			imod.close()

			Pickler()(file("setup.pyk", "w")).dump(CFG)

		# complete distribution initialization
		d = self.distribution
		d.version = CFG['VERSION']
		d.data_files = [(CFG['INCLUDE_DST'], CFG["XINCLUDES"])]
		EXT = Extension(
			CFG['XPATH'],
			CFG['XSOURCES'],
			include_dirs = CFG['I'],
			extra_compile_args = [
				'-Wall',
				'-DPGV_MM=' + CFG['PGV_MM']
			] + CFG['DEFINES'] + CFG['UNDEFINES']
		)
		d.ext_modules = [EXT]
distconfig.config = config

from distutils.command.build import build
_old_build_run = build.run
def _new_build_run(self):
	self.run_command('config')
	_old_build_run(self)
build.run = _new_build_run

from distutils.command.clean import clean
_old_clean_run = clean.run
def _new_clean_run(self):
	try:
		CFG = Unpickler()(file('setup.pyk', 'r')).load()
		print 'removing ' + CFG['XPPI']
		os.remove(CFG['XPPI'])
		print 'removing setup.pyk'
		os.remove('setup.pyk')
	except:
		pass
	_old_clean_run(self)
clean.run = _new_clean_run

SETUPDIR = os.path.dirname(sys.argv[0])
OLDCWD = os.getcwd()
os.chdir(SETUPDIR)

try:
	setup(
		name = 'postgres',
		description = 'Postgres interface extension module and package space',
		author = 'James William Pye',
		author_email = 'flaw@rhid.com',
		url = 'http://gborg.postgresql.org/project/postgrespy',
		packages = ['postgres']
	)
finally:
	os.chdir(OLDCWD)
