/* Module:          SQLNumResultCols.c
 *
 * Description:     Returns the number of columns in a result set.
 *
 * Classes:         
 *
 * API functions:   SQLNumResultCols
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLNumResultCols(
								   SQLHSTMT			hDrvStmt,
								   SQLSMALLINT		*pnColumnCount
								   )
{
	static char *func="SQLNumResultCols";
	StatementClass *stmt = (StatementClass *) hDrvStmt;
	QResultClass *result;
	char parse_ok;

	if ( ! stmt)
	{
		SC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	SC_clear_error(stmt);    

	parse_ok = FALSE;
	if (globals.parse && stmt->statement_type == STMT_TYPE_SELECT)
	{

		if (stmt->parse_status == STMT_PARSE_NONE)
		{
			mylog("SQLNumResultCols: calling parse_statement on stmt=%u\n", stmt);
			parse_statement(stmt);
		}

		if (stmt->parse_status != STMT_PARSE_FATAL)
		{
			parse_ok = TRUE;
			*pnColumnCount = stmt->nfld;
			mylog("PARSE: SQLNumResultCols: *pnColumnCount = %d\n", *pnColumnCount);
		}
	}

	if ( ! parse_ok)
	{

		SC_pre_execute(stmt);       
		result = SC_get_Result(stmt);

		mylog("SQLNumResultCols: result = %u, status = %d, numcols = %d\n", result, stmt->status, result != NULL ? QR_NumResultCols(result) : -1);
		if (( ! result) || ((stmt->status != STMT_FINISHED) && (stmt->status != STMT_PREMATURE)) )
		{
			/* no query has been executed on this statement */
			stmt->errornumber = STMT_SEQUENCE_ERROR;
			stmt->errormsg = "No query has been executed with that handle";
			SC_log_error(func, "", stmt);
			return SQL_ERROR;
		}

		*pnColumnCount = QR_NumResultCols(result);
	}

	return SQL_SUCCESS;
}


