'	Frank Lupo (Wolf) !! 
'	frank_lupo@email.it
'
'	This is a Psql command for Postgresql write in Visual Basic Script
'
'	main program
'
Option Explicit

'Inclue a file in current script 
Public Function Include(FileInclude)
Dim Fso,Ifile
Const ForReading=1

	Set Fso = CreateObject("Scripting.FileSystemObject")
	If Fso.FileExists(FileInclude) Then
		'	read file
   		Set Ifile = Fso.OpenTextFile(FileInclude, ForReading)
       	Include = Ifile.ReadAll()
      	Set Fso = Nothing
	Else
		'	Error not exist file
       	Msgbox "Include Fallied !!" & vbcrlf & "File " & FileInclude & " Not exist !!",VbSystemModal + VbCritical
       	Include = "Wscript.Quit"
	End If
End Function

'////////////////////////////////
'Start initializon

'Include Path 
Dim szIncludePath
Const PATH_INCLUDE="Include"
Const PATH_EXPORT="Export"
Const PATH_HELP="Help"

szIncludePath=Mid(WScript.ScriptFullName,1,Len(WScript.ScriptFullName)-Len(WScript.ScriptName)) & PATH_INCLUDE & "\"

'Vbs Const
Execute Include(szIncludePath & "VbsConst.vbs")

'Init Applications
Execute Include(szIncludePath & "App.vbs")
Dim App
Set App = New ClsApplications

'Data for proramm
Execute Include(szIncludePath & "Data.vbs")
Set App.Data = New ClsData

'Message
Execute Include(szIncludePath & "Message.vbs")
Set App.Data.Message = New ClsMessage

'Utility
Execute Include(szIncludePath & "Utility.vbs")
Set App.Data.Utility = New ClsUtility

'Connection Db
Execute Include(szIncludePath & "Db.vbs")
Set App.Data.ConDb = New ClsConDb

'Print
Execute Include(szIncludePath & "Print.vbs")
Set App.Data.Print = New ClsPrint

'Describe
Execute Include(szIncludePath & "Describe.vbs")
Set App.Data.Describe = New ClsDescribe

'Prompt
Execute Include(szIncludePath & "Prompt.vbs")

'Line prompt
Dim LinePrompt(3),FlagPrompt

'Sql command
Dim szSqlIstr,szOldSqlIstr

'////////////////////////////////////
'Main Program

Sub Main()
Dim objArgs,szTemp,WshShell,WshNetwork,szTemp1

	'Verify number parameter
	if WScript.Arguments.count <= 0 then 
		Wscript.Echo App.Data.Message.Help()
		exit sub
	end if

	App.Title="Psql Vbs"
	App.ProductName="PsqlVbs"
	App.Major=1
	App.Minor=0
	App.Revision=1

	Set objArgs = WScript.Arguments
	Set WshShell = WScript.CreateObject("WScript.Shell")

	'Verify if program to start using cscript
	If App.ComplierType <> RUN_USING_CSCRIPT Then
		'	Run program using Cscript
		szTemp=""
		For Each objArgs in WScript.Arguments
			szTemp = szTemp & " " & objArgs
		Next
		szTemp=Trim(szTemp)

		WshShell.Run "cmd /K " & CSCRIPT_PROGRAM & " //nologo " & WScript.ScriptFullName & " " & szTemp
		WScript.quit
	End If

	'Init session in history file
	szTemp="--   " & String(60,"=") & vbcrlf
	App.Data.Utility.FileSystem.WriteFile App.Data.Setting.HistoryFile,szTemp,ForAppending
	szTemp="--   " & String(60,"=") & vbcrlf
	App.Data.Utility.FileSystem.WriteFile App.Data.Setting.HistoryFile,szTemp,ForAppending
	szTemp="--   " & Now & "   Init session" & vbcrlf
	App.Data.Utility.FileSystem.WriteFile App.Data.Setting.HistoryFile,szTemp,ForAppending
	szTemp="--   " & String(60,"=") & vbcrlf
	App.Data.Utility.FileSystem.WriteFile App.Data.Setting.HistoryFile,szTemp,ForAppending
	szTemp="--   " & String(60,"=") & vbcrlf
	App.Data.Utility.FileSystem.WriteFile App.Data.Setting.HistoryFile,szTemp,ForAppending
		
	'external Editor (es. notepade)
	App.Data.Setting.Editor="NotePad"
	szTemp=App.Data.Utility.Env.GetEnv("PSQLVBS_EDITOR","USER")
	if len(szTemp) > 0 then 
		App.Data.Setting.Editor=szTemp
	else
		App.Data.Utility.Env.SetEnv "PSQLVBS_EDITOR",App.Data.Setting.Editor,"USER"
	end if

	'Default data	
	Set WshNetwork = CreateObject("WScript.Network")

	'Port
	App.Data.Setting.Database.Port=5432
	szTemp=App.Data.Utility.Env.GetEnv("PGPORT","USER")
	if len(szTemp) > 0 then App.Data.Setting.Database.Port=szTemp

	'UserName
	App.Data.Setting.Database.User=WshNetwork.UserName
	szTemp=App.Data.Utility.Env.GetEnv("PGUSER","USER")
	if len(szTemp) > 0 then App.Data.Setting.Database.User=szTemp

	'Host
	App.Data.Setting.Database.Host=WshNetwork.ComputerName
	szTemp=App.Data.Utility.Env.GetEnv("PGHOST","USER")
	if len(szTemp) > 0 then App.Data.Setting.Database.Host=szTemp

	'Database
	szTemp=App.Data.Utility.Env.GetEnv("PGDATABASE","USER")
	if len(szTemp) > 0 then App.Data.Setting.Database.Database=szTemp

	'///////////////////////////
	'Scan parms
	Set objArgs=WScript.Arguments
	If objArgs.Named.Exists("VERSION") then
		'Version
		Wscript.Echo App.Data.Message.Version()
		Wscript.quit
	ElseIf objArgs.Named.Exists("HELP") then
		'Help
		Wscript.Echo App.Data.Message.Usage()
		Wscript.quit
	End If

	'User
	szTemp=App.Data.Setting.Database.User
	GetDataArg szTemp,objArgs,"USER"
	App.Data.Setting.Database.User=szTemp

	'Host
	szTemp=App.Data.Setting.Database.Host
	GetDataArg szTemp,objArgs,"HOST"
	App.Data.Setting.Database.Host=szTemp

	'Database
	szTemp=App.Data.Setting.Database.Database
	GetDataArg szTemp,objArgs,"DB"
	App.Data.Setting.Database.Database=szTemp

	'Port
	szTemp=App.Data.Setting.Database.Port
	GetDataArg szTemp,objArgs,"PORT"
	App.Data.Setting.Database.Port=szTemp

	'Prompt for password
	If objArgs.Named.Exists("PWD") Then 
		szTemp=objArgs.Named.Item("PWD")
		if len(trim(szTemp)) = 0 then
			Wscript.StdOut.Write "Password: "
			szTemp=WScript.StdIn.ReadLine
		end if
		App.Data.Setting.Database.Password=szTemp
	end if

	'Open connection
	StartConDb

	'Display queries
	If objArgs.Named.Exists("ECHOQ") Then App.Data.ConDb.DisplayQueries=True

	'Verify if user is super user
	App.Data.ConDb.Execute "SELECT usesuper FROM pg_user WHERE usename = '" & App.Data.ConDb.User & "'"
	App.Data.Setting.SuperUser=App.Data.ConDb.ResultSet("usesuper")

	'Set line prompt
	FlagPrompt=0
	if App.Data.Setting.SuperUser=1 then
		LinePrompt(0)=App.Data.Setting.Database.Database & "=# "
		LinePrompt(1)=App.Data.Setting.Database.Database & "-# "
		LinePrompt(2)=App.Data.Setting.Database.Database & "'# "
		LinePrompt(3)=App.Data.Setting.Database.Database & """# "
	else
		LinePrompt(0)=App.Data.Setting.Database.Database & "=> "
		LinePrompt(1)=App.Data.Setting.Database.Database & "-> "
		LinePrompt(2)=App.Data.Setting.Database.Database & "'> "
		LinePrompt(3)=App.Data.Setting.Database.Database & """> "
	end if

	'HTML table output mode 
	If objArgs.Named.Exists("HTML") Then App.Data.Print.Html=True

	'Single step mode
	If objArgs.Named.Exists("SSM") Then App.Data.Setting.SingleStepMode=True

	'Print rows only
	If objArgs.Named.Exists("PRO") Then App.Data.Print.PrintRowsOnly=True

	'Send query results to file
	If objArgs.Named.Exists("OUTF") Then 
		szTemp=objArgs.Named.Item("OUTF")
		if len(trim(szTemp)) > 0 Then GetPrompt "\o " & szTemp
	end if

	'list all database
	If objArgs.Named.Exists("LADB") then
		App.Data.Describe.ListAllDatabase False
		Wscript.quit
	End If

	'Execute commands from file
	If objArgs.Named.Exists("FILE") then
		szTemp=objArgs.Named.Item("FILE")
		if len(trim(szTemp)) > 0 then
			App.Data.Setting.CmdFromLineCommand=True
			szTemp = App.Data.Utility.FileSystem.ReadFile(szTemp,1)	
			for each szTemp1 in szTemp
				GetPrompt szTemp1
			next 
		end if
		Wscript.quit
	End if

	'Run only single command 
	If objArgs.Named.Exists("CMD") then
		App.Data.Setting.CmdFromLineCommand=True
		szTemp=objArgs.Named.Item("CMD")
		GetPrompt szTemp
		Wscript.quit
	End if

	'Help
	Execute Include(szIncludePath & "Help.vbs")
	Set App.Data.Help = New ClsHelp

	'///////////////////////////
	'loop propmpt
	Wscript.Echo App.Data.Message.Welcome

	'Echo Tips
	szTemp = App.Data.Utility.FileSystem.ReadFile(szIncludePath & "Tips.txt",1)	
	Randomize   
	wscript.echo vbcrlf & szTemp(Int((Ubound(szTemp) - 1 + 1) *  Rnd + 1)) & vbcrlf 

	szSqlIstr=""
	WScript.StdOut.Write LinePrompt(FlagPrompt)
	Do While Not WScript.StdIn.AtEndOfStream
		szTemp = WScript.StdIn.ReadLine
		GetPrompt szTemp
		WScript.StdOut.Write LinePrompt(FlagPrompt)
	Loop
End Sub

'////////////////////////////////////////////
'Set data using arguments 
Public Sub GetDataArg(Data,objArgs,Arg)
Dim szTemp

	If objArgs.Named.Exists(Arg) then
		szTemp=objArgs.Named.Item(Arg)
		If Len(szTemp)=0 then
			Wscript.Echo "Manca parametro !!"
			Wscript.quit
		Else
			Data=szTemp
		End If
	End If
End Sub

'Start Connection db
Public Function StartConDb()
Dim szTemp

	App.Data.ConDb.User=App.Data.Setting.Database.User
	App.Data.ConDb.Host=App.Data.Setting.Database.Host
	App.Data.ConDb.Database=App.Data.Setting.Database.Database
	App.Data.ConDb.Port=App.Data.Setting.Database.Port
	App.Data.ConDb.Password=App.Data.Setting.Database.Password
	If Not App.Data.ConDb.Connect then
		if App.Data.ConDb.ErrNumberSql = -2147467259 then
			'password is required
			Wscript.StdOut.Write "Password: "
			szTemp=WScript.StdIn.ReadLine
			if len(trim(szTemp))=0 then Wscript.quit
			App.Data.Setting.Database.Password=szTemp
			StartConDb
		else
			Wscript.Echo App.Data.ConDb.ErrSql
			Wscript.quit
		end if
	End If
End Function

'////////////////////////////
'Main Program
Main
