/*
Created		21/02/2003
Modified		7/01/2004
Project		tcap
Model		core
Company		The Company in Mianos
Author		Rob Fowler
Version		1.1
Database		PostgreSQL 7.3 
*/














Drop table "dnsentry";
Drop table "usage";
Drop table "protocol";








Create table "protocol"
(
	"protocol_number" Smallint NOT NULL Constraint "protocol_number_idx" UNIQUE ,
	"description" Text,
 primary key ("protocol_number")
);

Create table "usage"
(
	"src_ip_serial" integer NOT NULL,
	"port_src" integer NOT NULL,
	"dst_ip_serial" integer NOT NULL,
	"port_dst" integer NOT NULL,
	"protocol_number" Smallint NOT NULL,
	"interface" Text NOT NULL,
	"first_seen" Timestamp NOT NULL,
	"last_seen" Timestamp NOT NULL,
	"packets" integer NOT NULL,
	"volume" Bigint NOT NULL,
	"flushed" integer,
 primary key ("src_ip_serial","port_src","dst_ip_serial","port_dst","protocol_number","interface","first_seen")
);

Create table "dnsentry"
(
	"hostname" Text NOT NULL,
	"ip" Inet NOT NULL,
	"serial" Serial NOT NULL UNIQUE ,
	"mac" Macaddr,
 primary key ("serial")
);










Create unique index "ip_key" on "dnsentry" ("ip","hostname");







Alter table "usage" add  foreign key ("protocol_number") references "protocol" ("protocol_number") on update restrict on delete restrict;










COPY protocol (protocol_number, description) FROM stdin;
0	ip
1	icmp
2	igmp
3	ggp
4	ipencap
5	st
6	tcp
8	egp
12	pup
17	udp
20	hmp
22	xns-idp
27	rdp
29	iso-tp4
36	xtp
37	ddp
39	idpr-cmtp
41	ipv6
43	ipv6-route
44	ipv6-frag
50	ipv6-crypt
51	ipv6-auth
58	ipv6-icmp
59	ipv6-nonxt
60	ipv6-opts
73	rspf
81	vmtp
89	ospf
94	ipip
98	encap
\.



