
struct PrioRecord {
	struct timeval firstUpdate_;
	struct timeval lastUpdate_;
	PrioRecord() {
		memset(&firstUpdate_, 0, sizeof (struct timeval));
		memset(&lastUpdate_, 0, sizeof (struct timeval));
	}
	PrioRecord(PrioRecord *cr) {
		memcpy(&firstUpdate_, &cr->firstUpdate_, sizeof (struct timeval));
		memcpy(&lastUpdate_, &cr->lastUpdate_, sizeof (struct timeval));
	}
//	string	MakeKey() { char tmp[30]; sprintf(tmp, "%d", ii_); return string(tmp); }
	virtual string	MakeKey() = 0;
	virtual void	update(PrioRecord *cr) = 0;
	virtual PrioRecord *create() = 0;
    virtual void Print(ostream &os) = 0;
};

typedef list<PrioRecord *> PrioRecordList;
typedef PrioRecordList::iterator	PrioRecordListIter;

typedef map<string,	PrioRecordListIter> PrioRecordMap;
typedef PrioRecordMap::iterator PrioRecordMapIter;

struct PrioList {
	PrioRecordMap  crm_m;
	PrioRecordList crl_m;
	pthread_mutex_t mutex_;
	bool		live_;
	PrioList() : live_(true) {
		pthread_mutex_init(&mutex_, NULL);
	}
	void	Accumulate(PrioRecord *cr, struct timeval when);
	void	MakeListOfFlushItems(PrioRecordList *ulist, struct timeval *since = 0);
	void	Remaining() {
		cout << "in map " << crm_m.size() << " in list " << crl_m.size() << endl;
	}
};

