---
--- Author:
---         Patrick Duplouy, The Womble Snippet Group
---         patrick@blackbird.les4y.org
---         copyright(c) 2001 Patrick Duplouy
---
--- Version:
---         0.1 - postgreSQL
---             2001/06/15
---         0.2 - mySQL
---             2001/08/19
---                                                                             ---
--- The first usage of snippet used the postgreSQL with a lot of rules
--- so, don't expect this version use all variables
---

---
--- The snippet table
---
create table snippet (
	id			serial		PRIMARY KEY,
	up			char(64)	DEFAULT '',
	name			char(64)	NOT NULL DEFAULT 'no name',
	language		char(32)	NOT NULL DEFAULT 'php',
	version			char(8)		NOT NULL DEFAULT '0.1.0',
	code			text		NOT NULL DEFAULT '',
	doc			text		NOT NULL DEFAULT '',
	author			char(64)	NOT NULL DEFAULT '',
	depend			text		NOT NULL DEFAULT '',
	signer			text		NOT NULL DEFAULT '',
	signature		text		NOT NULL DEFAULT '',
	level			text		NOT NULL DEFAULT '',
	data_tag		int		DEFAULT 0,
	created_by		char(64),
	creation_date		timestamp,
	modified_by		char(64),
	modification_date	timestamp,
	deleted_flag		int		DEFAULT 0,
	deleted_by		char(64),
	deletion_date		timestamp,
	UNIQUE (up, name, language)
	);

create index snippet_idx on snippet using btree(name, language);
create index snippet_up_idx on snippet using btree(up);

