#include <string.h>
#include <stdlib.h>
//------------------------------------------------------------------------------
#include "main.h"
//------------------------------------------------------------------------------
void Edit::AppendString (char* buf)
{
	char* s;
	s = (char*)calloc( GetLength() + strlen(buf) + 1, sizeof(char) );
	GetString( s, GetLength()+1);
	strcat( s, buf );

	SetString ( s );
	free(s);
}
//------------------------------------------------------------------------------
EditOutput::EditOutput(HWND hwndParent, int id, BOOL initialState) : Edit(hwndParent, id, initialState)
{
	m_maxlen = sizeof(m_buffer)-1;
	m_len = 0;
	memset(m_buffer,0, sizeof(m_buffer));
}
//------------------------------------------------------------------------------
char * EditOutput::FifoAdd(char * string)
{
	int cb = strlen(string);
	int newlen = m_len+cb;

	// It just fits easily
	if(newlen < m_maxlen)
	{
		strcpy(&m_buffer[m_len], string);
		m_len = newlen;
	}
	else if(cb < m_maxlen)	// Need to move some stuf around
	{
		int offset_insert = m_maxlen - cb;	// Calculate proposed insert point
		int cbdiff = m_len - offset_insert;	// Difference between insert and len

		// Get minimum possible beginning of buffer
		char *s = &m_buffer[cbdiff];

		// Find end of line
		while(*s && !ISNL(*s))
			s++;

		if(*s == 0) // End of buffer with no new line!
		{	// Start fresh
			strcpy(m_buffer, string);
			m_len = cb;
		}
		else
		{	// Skip new line chars
			while(*s && ISNL(*s))
				s++;

			if(!*s)
			{	// Its all newlines as far as one can see
				strcpy(m_buffer, string);
				m_len = cb;
			}
			else
			{	// Everything's OK, just move stuff
				int cbremove = s - m_buffer;	// Count of bytes to remove
				int cbmove = m_len - cbremove;	// Amount of data to remove
				memmove(m_buffer, &m_buffer[cbremove], cbmove);
				strcpy(&m_buffer[cbmove], string);
				m_len = cbmove + cb;
			}
		}
	}
	else // String too big, truncate it
	{
		int diff = cb - m_maxlen;
		strcpy(m_buffer, &string[diff]);
		m_len = m_maxlen;
	}
	return m_buffer;
}
//------------------------------------------------------------------------------
void EditOutput::AppendString (char* buf)
{
	SetString(FifoAdd(buf));
	SendMessage (_hWnd, EM_LINESCROLL, 0, 0x7FFFFFFF);
}
//------------------------------------------------------------------------------
int EditOutput::AppendStringCheck (char* buf)
{
	AppendString (buf);
	::SendMessage (_hWnd, EM_SCROLL, (WPARAM)SB_PAGEDOWN, (LPARAM)0);
	if( strstr( buf, Prf.m_ready) != NULL )
	{
		return __FLAG_READY;
	}
	
	if( strstr( buf, Prf.m_shutdown) != NULL )
	{
		return __FLAG_SHUTDOWN;
	}
	return 0;
}
//------------------------------------------------------------------------------
void StateButton::SetSelect(BOOL fSelect)
{
	if(fSelect)
		Select();
	else
		UnSelect();
}
//------------------------------------------------------------------------------
