//------------------------------------------------------------------------------
//  Name                :   WinMaster
//      You can obtain the latest version at                                             
//      http://gborg.postgresql.org/project/winmaster/projdisplay.php
//      Here's a web interface to CVS tree
//      http://gborg.postgresql.org/project/winmaster/viewcvs/
//
//  Description         :   Windows console for PostgreSQL server
//
//  Date                :   17/01/03 11:36
//
//  Copyright           :   Igor Georgiev       gory@alphasoft-bg.com
//                          Alpha Soft Ltd      www.alphasoft-bg.com
//
//  Portions Copyright  :   Mark L. Woodward    markw@mohawksoft.com
//                          Mohawk Software     www.mohawksoft.com
//
//  Authors             :   If this code works  it was written by
//                          Igor Georgiev & Mark L. Woodward
//                          If not, we don't know who wrote it and 
//                          dont't even heard anything about it.
//------------------------------------------------------------------------------
// This program is free software. You can redistribute it and/or
// modify it under the terms of the Mozilla Public License 1.1 (MPL 1.1)
// (at your option) any later version.
// You can obtain the latest version at                                             
// http://www.opensource.org/licenses/
//------------------------------------------------------------------------------
// This program is distributed in the hope that it will be useful,                
// but WITHOUT ANY WARRANTY; without even the implied warranty of                 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                  
// Mozilla Public License for more details.    
// http://www.opensource.org/licenses/mozilla1.1.php                               
//------------------------------------------------------------------------------
#define __MAIN_CPP
//------------------------------------------------------------------------------
#include "main.h"
#include "stdio.h"
//------------------------------------------------------------------------------
BOOL CALLBACK DialogProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
	    case WM_INITDIALOG:
	        try
	        {
				SetWindowText(hwnd, Prf.m_title);
	            control = new Controller (hwnd);
	        }
	        catch (WinException e)
	        {
	            MessageBox (0, e.GetMessage (), MSG_EXCEPTION, MB_ICONEXCLAMATION | MB_OK);
	        }
	        catch (...)
	        {
	            MessageBox (0, MSG_UNKNOWN, MSG_EXCEPTION, MB_ICONEXCLAMATION | MB_OK);
	            return -1;
	        }
	        return TRUE;
	        
	    case WM_SIZE:
	    	if( wParam == SIZE_MINIMIZED )
	    	{
	    		control->Hide();
	    	}
	    	return TRUE;
	    	
     	case WM_ICON_NOTIFY:
     		control->OnTrayNotification(wParam, lParam);
     		return TRUE;
     		
	    case WM_COMMAND:
	        control->Command(hwnd, LOWORD(wParam), HIWORD (wParam));
	        return TRUE;
	        
	    case WM_DESTROY:
	        PostQuitMessage(0);
	        return TRUE;
	        
	    case WM_CLOSE:
        	if( ConsolePostmaster.IsChildRunning() )
        	{
           		if( MessageBox (hwnd, MSG_SHUTDOWN_SYSTEM, Prf.m_title, MB_ICONQUESTION | MB_YESNO	)==IDYES )
       				SignalCommand( GetCommandPid( Prf.m_pidfile ), __FAST_SHUTDOWN ); 
        		return FALSE;
        	}
        	else
        	{
	        	delete control;
	        	DestroyWindow (hwnd);
	        	return TRUE;
        	}
        	
        case WM_QUERYENDSESSION:
        	if( ConsolePostmaster.IsChildRunning() )
        	{
           		if( MessageBox (hwnd,MSG_SHUTDOWN_SYSTEM,Prf.m_title,MB_ICONQUESTION | MB_YESNO)==IDYES)
					SignalCommand( GetCommandPid( Prf.m_pidfile ), __FAST_SHUTDOWN );
        		return FALSE;
        	}
        	else
        	{
           		MessageBox (hwnd, MSG_SHUTDOWN_SYSTEM, Prf.m_title, MB_ICONQUESTION | MB_YESNO);
        		return TRUE;
        	}
    }
    return FALSE;
}
//------------------------------------------------------------------------------
#ifndef _MSC_VER
extern int __argc;
extern char **__argv;
#endif
//------------------------------------------------------------------------------
int WINAPI WinMain (HINSTANCE hInst, HINSTANCE hPrevInst, char * cmdParam, int cmdShow)
{
	BOOL fPrerun;
	PROCESS_INFORMATION pi;
    TheInstance = hInst;

    HWND hDialog = 0;
	char *profile = NULL;

    hDialog = CreateDialog (hInst, MAKEINTRESOURCE (IDD_MAIN), 0, (DLGPROC)DialogProc);
    if (!hDialog)
    {
        ShowLastError( MSG_INTERNALERROR );
        return 1;
    }

	// If an optional profile added to command line, use it
	if(__argc > 1)
		profile = __argv[1];

    // Read the profile
    if( !ProfileRead(profile) )
    	DialogBox (TheInstance, MAKEINTRESOURCE (IDD_OPTIONS), hDialog, (DLGPROC)DialogProcOpt);

	// If there is a pre run program, run it
	if (Prf.m_prerun[0])
		fPrerun = RunProgram(Prf.m_prerun, Prf.m_bindir, &pi);

	// Queue a start
	PostMessage(hDialog, WM_COMMAND, IDB_START, 0L);
   
    MSG  msg;
    int status;
    while(1)
    {
        status = GetMessage (&msg, 0, 0, 0);
        if (status == -1)
			return -1;
		else if(status == 0)
			break;
        else if (!IsDialogMessage (hDialog, &msg))
        {
            TranslateMessage ( &msg );
            DispatchMessage ( &msg );
        }
    }

	if(fPrerun)
		TerminateProcess(pi.hProcess, 0);

    return msg.wParam;
}
//------------------------------------------------------------------------------
