/*
 * Generated by XCodeGen v0.1
 * Sun Jun 16 19:57:29 EDT 2002
 */

package output.dao;

import java.util.HashSet;
import java.util.Set;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import output.dto.DocumentDTO;
    import output.dto.ContentDTO;
    import output.dao.ContentDAO;

/**
 * 
 *
 * @author 
 * @version 
 *
 * @see DocumentDTO
 */
public class DocumentDAO
{
    /** INSERT SQL statement */
    public static final String SQL_INSERT = "INSERT INTO Document(url,_pk) VALUES(?,?)";
    
    /** SELECT SQL statement */
    public static final String SQL_SELECT = "SELECT CONTENT.id,CONTENT.creationDate,CONTENT.lastUpdate,CONTENT.ownerId,CONTENT.updaterId,Document.url FROM Document INNER JOIN CONTENT ON Document._pk=CONTENT.id";
    
    /** UPDATE SQL statement */
    public static final String SQL_UPDATE = "UPDATE Document SET url=?";
    
    /** Delete SQL Statement */
    public static final String SQL_DELETE = "DELETE FROM Document";

    /** Active connection */
    private Connection cnn;
    
    
////////////////////////////////////
// Constructors
////////////////////////////////////

    public DocumentDAO( Connection cnn )
    {
        if ( cnn == null )  throw new IllegalArgumentException( "cnn is null" );
        
        this.cnn = cnn;
    }
    

////////////////////////////////////
// Public methods
////////////////////////////////////
    
    /**
     * Persist a Document into the database
     *
     * @param       Document to persist
     * @return      value of the primary key of the object persisted
     * @throws      SQLException if any error occurs
     */
    public int create( DocumentDTO data ) throws SQLException
    {
        PreparedStatement stmt = null;
        try
        {

            // Create the super-object
            ContentDAO superdao = new ContentDAO ( cnn );
            superdao.create( data );

            // Create the object
            stmt = cnn.prepareStatement( SQL_INSERT, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
            
                            
        stmt.setString( 1, data.getUrl() );
                                
        stmt.setInt( 2, data.getId() );
    
            stmt.executeUpdate();
            
            return data.getId();
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

    /**
     * Persist modification on a Document into the database
     *
     * @param       Document to persist
     * @return      true if the object has been updated, false if not
     * @throws      SQLException if any error occurs
     */
    public boolean update( DocumentDTO data ) throws SQLException
    {
        PreparedStatement stmt = null;


        // Update the super-object
        ContentDAO superdao = new ContentDAO ( cnn );
        if ( superdao.update( data ) )
        {
            // Update the object
            try
            {
                stmt = cnn.prepareStatement( SQL_UPDATE + " WHERE _pk=?", ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );

        
                                    
        stmt.setString( 1, data.getUrl() );
                                            
        stmt.setInt( 2, data.getId() );
                    
                stmt.executeUpdate();
                return true;
            }
            finally
            {
                if ( stmt != null )
                {
                    try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
                }
            }
        }
        return false;
    }

    /**
     * Remove a Document from the database
     *
     * @param       pk  Primary key of the Document to remove
     * @throws      SQLException if any error occurs
     */
    public void removeByPK( int pk ) throws SQLException
    {
        PreparedStatement stmt = null;
        try
        {

            // Remove the super-object
            ContentDAO superdao = new ContentDAO ( cnn );
            superdao.removeByPK( pk );
            
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }
    
    /**
     * Find a Document by its primary key
     *
     * @param pk    primary key of the Document requested
     * @return      Document found, <code>null</code> if nothing found
     * @throws      SQLException if any error occurs
     */
    public DocumentDTO findByPK( int pk ) throws SQLException
    {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try
        {
            String sql = SQL_SELECT + " WHERE Document._pk=?";
            stmt = cnn.prepareStatement( sql, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
                
                                
        stmt.setInt( 1, pk );
    
            rs = stmt.executeQuery();
            return rs.next() ? newDataObject( rs ) : null;
        }
        finally
        {
            if ( rs != null )
            {
                try{    rs.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }



//////////////////////////////////////////////////
// Private methods
//////////////////////////////////////////////////

    private boolean exists( DocumentDTO data ) throws SQLException
    {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try
        {
            stmt = cnn.prepareStatement( "SELECT _pk FROM Document WHERE _pk=?", ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
            
                                
        stmt.setInt( 1, data.getId() );
                
            rs = stmt.executeQuery();
            return rs.next();
        }
        finally
        {
            if ( rs != null )
            {
                try{    rs.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

    private Set filter( ResultSet rs, int offset, int maxcount ) throws SQLException
    {
        HashSet set = new HashSet();
        for( int i=0, count=0 ; rs.next() && ( maxcount > count ) ; i++ )
        {
            if ( i >= offset )
            {
                set.add( newDataObject( rs ) );
                count++;
            }
        }
        return set;
    }

    private DocumentDTO newDataObject( ResultSet rs ) throws SQLException
    {
        DocumentDTO data = new DocumentDTO();
        

                        data.setId( rs.getInt( 1 ) );

                        data.setCreationDate( rs.getDate( 2 ) );

                        data.setLastUpdate( rs.getDate( 3 ) );

                        data.setOwnerId( rs.getInt( 4 ) );

                        data.setUpdaterId( rs.getInt( 5 ) );

                        data.setUrl( rs.getString( 6 ) );

        return data;
    }
}
